/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionApplierFacade
implements TransactionApplier {
    final TransactionApplier[] appliers;

    TransactionApplierFacade(TransactionApplier ... appliers) {
        this.appliers = appliers;
    }

    @Override
    public void close() throws Exception {
        for (int i = this.appliers.length - 1; i >= 0; --i) {
            this.appliers[i].close();
        }
    }

    public boolean visit(StorageCommand element) throws IOException {
        for (TransactionApplier applier : this.appliers) {
            if (!((Command)element).handle(applier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitMetaDataCommand(Command.MetaDataCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) throws IOException {
        return this.visit(command);
    }

    @Override
    public boolean visitIndexUpdateCommand(IndexUpdateCommand command) throws IOException {
        return this.visit(command);
    }
}

