/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV5_23;
import org.neo4j.internal.recordstorage.idx.PositiveNumberEncoder;
import org.neo4j.internal.recordstorage.idx.value.PeekableChannel;
import org.neo4j.internal.recordstorage.idx.value.ValueStream;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

class LogCommandSerializationV5_25
extends LogCommandSerializationV5_23 {
    static final LogCommandSerializationV5_25 INSTANCE = new LogCommandSerializationV5_25();

    LogCommandSerializationV5_25() {
    }

    @Override
    protected Command readIndexUpdateCommand(ReadableChannel channel) throws IOException {
        return LogCommandSerializationV5_25.read(this, channel);
    }

    @Override
    public void writeIndexUpdateCommand(WritableChannel channel, IndexUpdateCommand command) throws IOException {
        channel.put((byte)28);
        LogCommandSerializationV5_25.write(channel, command);
    }

    @Override
    public KernelVersion kernelVersion() {
        return KernelVersion.V5_25;
    }

    static void write(WritableChannel out, IndexUpdateCommand command) throws IOException {
        boolean tokenIndex = LogCommandSerializationV5_25.isTokenIndex(command);
        LogCommandSerializationV5_25.writeHeader(out, command, tokenIndex);
        PositiveNumberEncoder.writeNumber(out, command.getIndexId());
        PositiveNumberEncoder.writeNumber(out, command.getEntityId());
        if (tokenIndex) {
            LogCommandSerializationV5_25.writeTokenPart(out, (TokenIndexUpdateCommand)command);
        } else {
            LogCommandSerializationV5_25.writeValuePart(out, (ValueIndexUpdateCommand)command);
        }
    }

    static IndexUpdateCommand read(LogCommandSerialization serialization, ReadableChannel in) throws IOException {
        byte header = in.get();
        boolean tokenIndex = LogCommandSerializationV5_25.isTokenIndex(header);
        UpdateMode updateMode = LogCommandSerializationV5_25.readUpdateMode(header);
        long indexId = PositiveNumberEncoder.readNumber(in);
        long entityId = PositiveNumberEncoder.readNumber(in);
        if (tokenIndex) {
            return LogCommandSerializationV5_25.readTokenPart(serialization, in, updateMode, indexId, entityId);
        }
        return LogCommandSerializationV5_25.readValuePart(serialization, in, updateMode, indexId, entityId);
    }

    private static boolean isTokenIndex(byte header) {
        return (header & 0x80) == 0;
    }

    private static UpdateMode readUpdateMode(byte header) {
        int modeOrdinal = header >> 5 & 3;
        return switch (modeOrdinal) {
            case 0 -> UpdateMode.ADDED;
            case 1 -> UpdateMode.CHANGED;
            case 2 -> UpdateMode.REMOVED;
            default -> throw new IllegalArgumentException("Weird header: " + header);
        };
    }

    private static void writeValuePart(WritableChannel out, ValueIndexUpdateCommand command) throws IOException {
        switch (command.getUpdateMode()) {
            case ADDED: 
            case REMOVED: {
                LogCommandSerializationV5_25.writeValueArray(out, command.getAfter());
                break;
            }
            case CHANGED: {
                LogCommandSerializationV5_25.writeValueArray(out, command.getBefore());
                LogCommandSerializationV5_25.writeValueArray(out, command.getAfter());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static ValueIndexUpdateCommand readValuePart(LogCommandSerialization serialization, ReadableChannel in, UpdateMode updateMode, long indexId, long entityId) throws IOException {
        switch (updateMode) {
            case ADDED: 
            case REMOVED: {
                Value[] values = LogCommandSerializationV5_25.readValueArray(in);
                return new ValueIndexUpdateCommand(serialization, updateMode, indexId, entityId, null, values);
            }
            case CHANGED: {
                Value[] before = LogCommandSerializationV5_25.readValueArray(in);
                Value[] values = LogCommandSerializationV5_25.readValueArray(in);
                return new ValueIndexUpdateCommand(serialization, updateMode, indexId, entityId, before, values);
            }
        }
        throw new IllegalArgumentException();
    }

    private static void writeValueArray(WritableChannel out, Value[] values) throws IOException {
        PositiveNumberEncoder.writeNumber(out, values.length);
        for (Value value : values) {
            ValueStream.write(out, (AnyValue)value);
        }
    }

    private static Value[] readValueArray(ReadableChannel in) throws IOException {
        int length = (int)PositiveNumberEncoder.readNumber(in);
        Value[] values = new Value[length];
        PeekableChannel peekableChannel = new PeekableChannel(in);
        for (int i = 0; i < length; ++i) {
            values[i] = ValueStream.readValue(peekableChannel);
        }
        return values;
    }

    private static void writeTokenPart(WritableChannel out, TokenIndexUpdateCommand command) throws IOException {
        switch (command.getUpdateMode()) {
            case ADDED: 
            case REMOVED: {
                LogCommandSerializationV5_25.writeTokenArray(out, command.getAfter());
                break;
            }
            case CHANGED: {
                LogCommandSerializationV5_25.writeTokenArray(out, command.getBefore());
                LogCommandSerializationV5_25.writeTokenArray(out, command.getAfter());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static TokenIndexUpdateCommand readTokenPart(LogCommandSerialization serialization, ReadableChannel in, UpdateMode updateMode, long indexId, long entityId) throws IOException {
        switch (updateMode) {
            case ADDED: 
            case REMOVED: {
                int[] values = LogCommandSerializationV5_25.readTokenArray(in);
                return new TokenIndexUpdateCommand(serialization, updateMode, indexId, entityId, null, values);
            }
            case CHANGED: {
                int[] before = LogCommandSerializationV5_25.readTokenArray(in);
                int[] values = LogCommandSerializationV5_25.readTokenArray(in);
                return new TokenIndexUpdateCommand(serialization, updateMode, indexId, entityId, before, values);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int[] readTokenArray(ReadableChannel in) throws IOException {
        int length = (int)PositiveNumberEncoder.readNumber(in);
        int[] tokens = new int[length];
        for (int i = 0; i < length; ++i) {
            tokens[i] = (int)PositiveNumberEncoder.readNumber(in);
        }
        return tokens;
    }

    private static void writeTokenArray(WritableChannel out, int[] tokens) throws IOException {
        PositiveNumberEncoder.writeNumber(out, tokens.length);
        for (int token : tokens) {
            PositiveNumberEncoder.writeNumber(out, token);
        }
    }

    private static void writeHeader(WritableChannel out, IndexUpdateCommand command, boolean tokenIndex) throws IOException {
        byte header = 0;
        if (!tokenIndex) {
            header = -128;
        }
        header = (byte)(header | (byte)(command.getUpdateMode().ordinal() << 5));
        out.put(header);
    }

    private static boolean isTokenIndex(IndexUpdateCommand command) {
        return command instanceof TokenIndexUpdateCommand;
    }
}

