/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV4_2;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.util.BitUtils;

class LogCommandSerializationV4_3_D3
extends LogCommandSerializationV4_2 {
    static final LogCommandSerializationV4_3_D3 INSTANCE = new LogCommandSerializationV4_3_D3();

    LogCommandSerializationV4_3_D3() {
    }

    @Override
    public KernelVersion kernelVersion() {
        return KernelVersion.V4_3_D4;
    }

    @Override
    protected Command readMetaDataCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        MetaDataRecord before = LogCommandSerializationV4_3_D3.readMetaDataRecord(id, channel);
        MetaDataRecord after = LogCommandSerializationV4_3_D3.readMetaDataRecord(id, channel);
        return new Command.MetaDataCommand((LogCommandSerialization)this, before, after);
    }

    private static MetaDataRecord readMetaDataRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        long value = channel.getLong();
        MetaDataRecord record = new MetaDataRecord();
        record.setId(id);
        if (BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue())) {
            record.initialize(true, value);
        }
        return record;
    }

    @Override
    protected Command readGroupDegreeCommand(ReadableChannel channel) throws IOException {
        long key = channel.getLong();
        long delta = channel.getLong();
        return new Command.GroupDegreeCommand(this, Command.GroupDegreeCommand.groupIdFromCombinedKey(key), Command.GroupDegreeCommand.directionFromCombinedKey(key), delta);
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_3_D3.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_3_D3.readRelationshipGroupRecord(id, channel);
        LogCommandSerializationV4_3_D3.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean hasExternalDegreesOut = BitUtils.bitFlag((int)flags, (int)32);
        boolean hasExternalDegreesIn = BitUtils.bitFlag((int)flags, (int)64);
        boolean hasExternalDegreesLoop = BitUtils.bitFlag((int)flags, (int)128);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setHasExternalDegreesOut(hasExternalDegreesOut);
        record.setHasExternalDegreesIn(hasExternalDegreesIn);
        record.setHasExternalDegreesLoop(hasExternalDegreesLoop);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_3_D3.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_3_D3.readRelationshipGroupExtendedRecord(id, channel);
        LogCommandSerializationV4_3_D3.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        boolean hasExternalDegreesOut = BitUtils.bitFlag((int)flags, (int)32);
        boolean hasExternalDegreesIn = BitUtils.bitFlag((int)flags, (int)64);
        boolean hasExternalDegreesLoop = BitUtils.bitFlag((int)flags, (int)128);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setHasExternalDegreesOut(hasExternalDegreesOut);
        record.setHasExternalDegreesIn(hasExternalDegreesIn);
        record.setHasExternalDegreesLoop(hasExternalDegreesLoop);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }
}

