/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.storageengine.api.StorageEngineTransaction;

class CountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final CountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final StorageEngineTransaction commandsBatch;
    private CountsUpdater countsUpdater;
    private DegreeUpdater degreesUpdater;
    private boolean haveUpdates;
    private boolean countsUpdaterClosed;
    private boolean degreesUpdaterClosed;

    CountsStoreTransactionApplier(CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore, StorageEngineTransaction commandsBatch) {
        this.countsStore = countsStore;
        this.groupDegreesStore = groupDegreesStore;
        this.commandsBatch = commandsBatch;
    }

    @Override
    public void close() {
        this.closeCountsUpdatersIfOpen();
    }

    private void closeCountsUpdatersIfOpen() {
        if (!this.countsUpdaterClosed) {
            this.countsUpdater().close();
            this.countsUpdaterClosed = true;
        }
        if (!this.degreesUpdaterClosed) {
            this.degreesUpdater().close();
            this.degreesUpdaterClosed = true;
        }
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementNodeCount(command.labelId(), command.delta());
        return false;
    }

    private CountsUpdater countsUpdater() {
        if (this.countsUpdater == null) {
            this.countsUpdater = this.countsStore.updater(this.commandsBatch.transactionId(), this.commandsBatch.commandBatch().isLast(), this.commandsBatch.cursorContext());
        }
        return this.countsUpdater;
    }

    private DegreeUpdater degreesUpdater() {
        if (this.degreesUpdater == null) {
            this.degreesUpdater = this.groupDegreesStore.updater(this.commandsBatch.transactionId(), this.commandsBatch.commandBatch().isLast(), this.commandsBatch.cursorContext());
        }
        return this.degreesUpdater;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementRelationshipCount(command.startLabelId(), command.typeId(), command.endLabelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        assert (!this.haveUpdates) : "Assumed that a schema transaction wouldn't also contain data commands affecting counts store, but was proven wrong with this transaction";
        this.closeCountsUpdatersIfOpen();
        return false;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        this.haveUpdates = true;
        this.degreesUpdater().increment(command.groupId(), command.direction(), command.delta());
        return false;
    }
}

