/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.ImportMemoryCalculator;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.staging.WeightedExternalProgressReporter;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.store.RelationshipStore;

public class HumanUnderstandableExecutionMonitor
implements ExecutionMonitor {
    private static final String ESTIMATED_REQUIRED_MEMORY_USAGE = "Estimated required memory usage";
    private static final String ESTIMATED_DISK_SPACE_USAGE = "Estimated disk space usage";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES = "Estimated number of relationship properties";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIPS = "Estimated number of relationships";
    private static final String ESTIMATED_NUMBER_OF_NODE_PROPERTIES = "Estimated number of node properties";
    private static final String ESTIMATED_NUMBER_OF_NODES = "Estimated number of nodes";
    private final Monitor monitor;
    private final PrintStream out;
    private final PrintStream err;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final WeightedExternalProgressReporter externalProgressIndicator;
    private DependencyResolver dependencyResolver;
    private PageCacheArrayFactoryMonitor pageCacheArrayFactoryMonitor;
    private double externalProgressNodeWeight;
    private double externalProgressRelationshipWeight;
    private ProgressListener progressListener;
    private long lastReportedProgress;
    private ImportStage currentStage;
    private long stageStartTime;

    public HumanUnderstandableExecutionMonitor(Monitor monitor, PrintStream out, PrintStream err) {
        this.monitor = monitor;
        this.out = out;
        this.err = err;
        this.progressMonitorFactory = ProgressMonitorFactory.textual((OutputStream)out, (boolean)true, (int)10, (int)5, (int)20);
        this.externalProgressIndicator = new WeightedExternalProgressReporter(monitor);
    }

    public void initialize(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        Input.Estimates estimates = (Input.Estimates)dependencyResolver.resolveDependency(Input.Estimates.class);
        BatchingNeoStores neoStores = (BatchingNeoStores)dependencyResolver.resolveDependency(BatchingNeoStores.class);
        IdMapper idMapper = (IdMapper)dependencyResolver.resolveDependency(IdMapper.class);
        this.pageCacheArrayFactoryMonitor = (PageCacheArrayFactoryMonitor)dependencyResolver.resolveDependency(PageCacheArrayFactoryMonitor.class);
        long biggestCacheMemory = ImportMemoryCalculator.estimatedCacheSize(neoStores, NodeRelationshipCache.memoryEstimation((long)estimates.numberOfNodes()), idMapper.memoryEstimation(estimates.numberOfNodes()));
        this.out.println();
        this.out.println(this.stageHeader("Import starting", ESTIMATED_NUMBER_OF_NODES, Format.count((long)estimates.numberOfNodes()), ESTIMATED_NUMBER_OF_NODE_PROPERTIES, Format.count((long)estimates.numberOfNodeProperties()), ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count((long)estimates.numberOfRelationships()), ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES, Format.count((long)estimates.numberOfRelationshipProperties()), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties() + estimates.sizeOfRelationshipProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)biggestCacheMemory)));
        this.out.println();
        long numNodes = Math.max(1L, estimates.numberOfNodes());
        long numRelationships = Math.max(1L, estimates.numberOfRelationships());
        long totalEntities = numNodes + numRelationships * 2L;
        this.externalProgressNodeWeight = (double)numNodes / (double)totalEntities * 0.8;
        this.externalProgressRelationshipWeight = (double)numRelationships / (double)totalEntities * 0.8;
    }

    private static long baselineMemoryRequirement(BatchingNeoStores neoStores) {
        return GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])new MemoryStatsVisitor.Visitable[]{neoStores});
    }

    private static long nodesDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfNodes() * (long)neoStores.getNodeStore().getRecordSize() + estimates.numberOfNodeLabels();
    }

    private static long relationshipsDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfRelationships() * (long)neoStores.getRelationshipStore().getRecordSize() * (long)(neoStores.usesDoubleRelationshipRecordUnits() ? 2 : 1);
    }

    public void start(StageExecution execution) {
        if (execution.getStageName().equals("Nodes")) {
            this.initializeNodeImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Relationships")) {
            this.endPrevious();
            this.initializeRelationshipImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Node Degrees")) {
            this.endPrevious();
            this.initializeLinking((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (execution.getStageName().equals("Count groups")) {
            this.endPrevious();
            this.initializeMisc((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.lastReportedProgress = 0L;
            this.progressListener.mark('-');
        }
    }

    private void endPrevious() {
        if (this.progressListener != null) {
            this.progressListener.close();
        }
        if (this.currentStage != null) {
            this.out.printf("%s COMPLETED in %s%n%n", this.currentStage.description(), Format.duration((long)(System.currentTimeMillis() - this.stageStartTime)));
        }
    }

    private void initializeNodeImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfNodes = estimates.numberOfNodes();
        long goal = idMapper.needsPreparation() ? numberOfNodes + HumanUnderstandableExecutionMonitor.weighted("Prepare node index", numberOfNodes * 4L) : numberOfNodes;
        this.startStage(ImportStage.nodeImport, goal, this.externalProgressNodeWeight, ESTIMATED_NUMBER_OF_NODES, Format.count((long)numberOfNodes), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(idMapper.memoryEstimation(numberOfNodes)))));
    }

    private void initializeRelationshipImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfRelationships = estimates.numberOfRelationships();
        this.startStage(ImportStage.relationshipImport, numberOfRelationships, this.externalProgressRelationshipWeight, ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count((long)numberOfRelationships), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfRelationshipProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])new MemoryStatsVisitor.Visitable[]{idMapper}))));
    }

    private void initializeLinking(BatchingNeoStores neoStores, DataStatistics distribution) {
        long relationshipRecordIdCount = neoStores.getRelationshipStore().getIdGenerator().getHighId();
        long actualRelationshipCount = distribution.getRelationshipCount();
        long goal = relationshipRecordIdCount + actualRelationshipCount * 2L + actualRelationshipCount * 2L;
        this.startStage(ImportStage.linking, goal, this.externalProgressRelationshipWeight, ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(NodeRelationshipCache.memoryEstimation((long)distribution.getNodeCount())))));
    }

    private void initializeMisc(BatchingNeoStores neoStores, DataStatistics distribution) {
        long actualNodeCount = distribution.getNodeCount();
        RelationshipStore relStore = neoStores.getRelationshipStore();
        long relationshipRecordIdCount = relStore.getIdGenerator().getHighId();
        long groupCount = neoStores.getTemporaryRelationshipGroupStore().getIdGenerator().getHighId();
        long goal = groupCount + groupCount + groupCount + actualNodeCount + relationshipRecordIdCount;
        this.startStage(ImportStage.postProcessing, goal, 0.2, ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores)));
    }

    private void updateProgress(long progress) {
        long diff = progress - this.lastReportedProgress;
        this.progressListener.add(diff);
        this.lastReportedProgress = progress;
    }

    private void printPageCacheAllocationWarningIfUsed() {
        String allocation = this.pageCacheArrayFactoryMonitor.pageCacheAllocationOrNull();
        if (allocation != null) {
            this.err.println();
            this.err.println("WARNING:");
            this.err.println(allocation);
        }
    }

    private void startStage(ImportStage stage, long goal, double externalProgressWeight, Object ... data) {
        this.stageStartTime = System.currentTimeMillis();
        this.currentStage = stage;
        this.progressListener = this.progressMonitorFactory.singlePart(this.stageHeader(stage.descriptionWithOrdinal(), data), goal, this.externalProgressIndicator.next(externalProgressWeight));
        this.currentStage = stage;
    }

    private String stageHeader(String description, Object ... data) {
        StringBuilder header = new StringBuilder(description).append(" ").append(Format.localDate());
        if (data.length > 0) {
            int i = 0;
            while (i < data.length) {
                header.append(String.format("%n  %s: %s", data[i++], data[i++]));
            }
        }
        return header.toString();
    }

    public void end(StageExecution execution, long totalTimeMillis) {
    }

    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        this.endPrevious();
        this.externalProgressIndicator.close();
        this.out.println();
        this.out.printf("IMPORT %s in %s. %s%n", successful ? "DONE" : "FAILED", Format.duration((long)totalTimeMillis), additionalInformation);
    }

    public long checkIntervalMillis() {
        return 200L;
    }

    public void check(StageExecution execution) {
        if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.updateProgress(HumanUnderstandableExecutionMonitor.progressOf(execution));
        }
    }

    private static boolean includeStage(StageExecution execution) {
        String name = execution.getStageName();
        return !name.equals("RelationshipGroup") && !name.equals("Node --> Relationship") && !name.equals("Gather");
    }

    private static double weightOf(String stageName) {
        if (stageName.equals("Prepare node index")) {
            return 0.5;
        }
        return 1.0;
    }

    private static long weighted(String stageName, long progress) {
        return (long)((double)progress * HumanUnderstandableExecutionMonitor.weightOf(stageName));
    }

    private static long progressOf(StageExecution execution) {
        Stat progressStat = HumanUnderstandableExecutionMonitor.findProgressStat(execution.steps());
        if (progressStat != null) {
            return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), progressStat.asLong());
        }
        long doneBatches = ((Step)Iterables.last((Iterable)execution.steps())).stats().stat((Key)Keys.done_batches).asLong();
        int batchSize = execution.getConfig().batchSize();
        return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), doneBatches * (long)batchSize);
    }

    private static Stat findProgressStat(Iterable<Step<?>> steps) {
        for (Step<?> step : steps) {
            Stat stat = step.stats().stat((Key)Keys.progress);
            if (stat == null) continue;
            return stat;
        }
        return null;
    }

    public static enum ImportStage {
        nodeImport("Node import"),
        relationshipImport("Relationship import"),
        linking("Relationship linking"),
        postProcessing("Post processing");

        private final String description;

        private ImportStage(String description) {
            this.description = description;
        }

        String descriptionWithOrdinal() {
            return String.format("(%d/%d) %s", this.ordinal() + 1, ImportStage.values().length, this.description);
        }

        String description() {
            return this.description;
        }
    }
}

