/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;

public class ReadGroupRecordsByCacheStep
extends ProcessorStep<PrimitiveLongCollections.RangedLongIterator> {
    private static final String READ_RELATIONSHIP_GROUPS_STEP_TAG = "readRelationshipGroupsStep";
    private final RecordStore<RelationshipGroupRecord> store;
    private final IdGenerator storeIdGenerator;
    private final NodeRelationshipCache cache;

    public ReadGroupRecordsByCacheStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, NodeRelationshipCache cache, CursorContextFactory contextFactory) {
        super(control, ">", config, 0, contextFactory, new StatsProvider[0]);
        this.store = store;
        this.storeIdGenerator = store.getIdGenerator();
        this.cache = cache;
    }

    protected void process(PrimitiveLongCollections.RangedLongIterator batch, BatchSender sender, CursorContext cursorContext, MemoryTracker memoryTracker) throws Throwable {
        try (NodeVisitor visitor = new NodeVisitor(sender, cursorContext);){
            this.cache.visitChangedNodes((NodeRelationshipCache.NodeChangeVisitor)visitor, 1, batch.startInclusive(), batch.endExclusive());
        }
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable,
    NodeRelationshipCache.GroupVisitor {
        private final BatchSender sender;
        private final CursorContext cursorContext;
        private List<RelationshipGroupRecord> batch = new ArrayList<RelationshipGroupRecord>();

        NodeVisitor(BatchSender sender, CursorContext cursorContext) {
            this.sender = sender;
            this.cursorContext = cursorContext;
        }

        public void change(long nodeId, ByteArray array) {
            ReadGroupRecordsByCacheStep.this.cache.getFirstRel(nodeId, (NodeRelationshipCache.GroupVisitor)this);
        }

        public long visit(long nodeId, int typeId, long out, long in, long loop) {
            long id = ReadGroupRecordsByCacheStep.this.storeIdGenerator.nextId(this.cursorContext);
            RelationshipGroupRecord record = ReadGroupRecordsByCacheStep.this.store.newRecord();
            record.setId(id);
            record.initialize(true, typeId, out, in, loop, nodeId, loop);
            this.batch.add(record);
            if (this.batch.size() >= ReadGroupRecordsByCacheStep.this.config.batchSize()) {
                this.send();
            }
            return id;
        }

        private void send() {
            this.sender.send((Object)this.batch.toArray(new RelationshipGroupRecord[0]));
            this.batch = new ArrayList<RelationshipGroupRecord>();
        }

        @Override
        public void close() {
            if (!this.batch.isEmpty()) {
                this.send();
            }
        }
    }
}

