/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import java.util.Collection;
import org.neo4j.consistency.checking.IdAssigningThreadLocal;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.PackedMultiFieldCache;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.memory.MemoryTracker;

public class DefaultCacheAccess
implements CacheAccess {
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    private final IdAssigningThreadLocal<CacheAccess.Client> clients = new IdAssigningThreadLocal<CacheAccess.Client>(){

        @Override
        protected CacheAccess.Client initialValue(int id) {
            return new DefaultClient(id);
        }
    };
    private final Collection<PropertyRecord>[] propertiesProcessed;
    private boolean forwardScan = true;
    private final PackedMultiFieldCache cache;
    private long recordsPerCPU;
    private final Counts counts;
    private long pivotId;

    public static ByteArray defaultByteArray(long highNodeId, MemoryTracker memoryTracker) {
        return NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newByteArray(highNodeId, new byte[11], memoryTracker);
    }

    public DefaultCacheAccess(ByteArray array, Counts counts, int threads) {
        this.counts = counts;
        this.propertiesProcessed = new Collection[threads];
        this.cache = new PackedMultiFieldCache(array, 40, 1);
    }

    @Override
    public CacheAccess.Client client() {
        return (CacheAccess.Client)this.clients.get();
    }

    @Override
    public void clearCache() {
        this.cache.clearParallel(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void setCacheSlotSizes(int ... slotSizes) {
        this.cache.setSlotSizes(slotSizes);
    }

    @Override
    public void setCacheSlotSizesAndClear(int ... slotSizes) {
        this.cache.setSlotSizes(slotSizes);
        this.cache.clearParallel(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public void setPivotId(long pivotId) {
        this.pivotId = pivotId;
    }

    private long translate(long id) {
        return id - this.pivotId;
    }

    @Override
    public void setForward(boolean forward) {
        this.forwardScan = forward;
    }

    @Override
    public boolean isForward() {
        return this.forwardScan;
    }

    @Override
    public void prepareForProcessingOfSingleStore(long recordsPerCPU) {
        this.clients.resetId();
        this.recordsPerCPU = recordsPerCPU;
    }

    private class DefaultClient
    implements CacheAccess.Client {
        private final int threadIndex;

        DefaultClient(int threadIndex) {
            this.threadIndex = threadIndex;
        }

        @Override
        public long getFromCache(long id, int slot) {
            return DefaultCacheAccess.this.cache.get(DefaultCacheAccess.this.translate(id), slot);
        }

        @Override
        public boolean getBooleanFromCache(long id, int slot) {
            return DefaultCacheAccess.this.cache.get(DefaultCacheAccess.this.translate(id), slot) != 0L;
        }

        @Override
        public void putToCache(long id, long ... values) {
            DefaultCacheAccess.this.cache.put(DefaultCacheAccess.this.translate(id), values);
        }

        @Override
        public void putToCacheSingle(long id, int slot, long value) {
            DefaultCacheAccess.this.cache.put(DefaultCacheAccess.this.translate(id), slot, value);
        }

        @Override
        public void clearCache(long index) {
            DefaultCacheAccess.this.cache.clear(index);
            DefaultCacheAccess.this.counts.incAndGet(Counts.Type.clearCache, this.threadIndex);
            DefaultCacheAccess.this.counts.incAndGet(Counts.Type.activeCache, this.threadIndex);
        }

        @Override
        public boolean withinBounds(long id) {
            return DefaultCacheAccess.this.recordsPerCPU == 0L || id >= (long)this.threadIndex * DefaultCacheAccess.this.recordsPerCPU && id < (long)(this.threadIndex + 1) * DefaultCacheAccess.this.recordsPerCPU;
        }

        @Override
        public void putPropertiesToCache(Collection<PropertyRecord> properties) {
            DefaultCacheAccess.this.propertiesProcessed[this.threadIndex] = properties;
        }

        @Override
        public Iterable<PropertyRecord> getPropertiesFromCache() {
            return this.cachedProperties(true);
        }

        @Override
        public PropertyRecord getPropertyFromCache(long id) {
            Collection<PropertyRecord> properties = this.cachedProperties(false);
            if (properties != null) {
                for (PropertyRecord property : properties) {
                    if (property.getId() != id) continue;
                    return property;
                }
            }
            return null;
        }

        private Collection<PropertyRecord> cachedProperties(boolean clear) {
            try {
                Collection<PropertyRecord> collection = DefaultCacheAccess.this.propertiesProcessed[this.threadIndex];
                return collection;
            }
            finally {
                if (clear) {
                    DefaultCacheAccess.this.propertiesProcessed[this.threadIndex] = null;
                }
            }
        }

        @Override
        public void incAndGetCount(Counts.Type type) {
            DefaultCacheAccess.this.counts.incAndGet(type, this.threadIndex);
        }

        public String toString() {
            return "Client[" + this.threadIndex + ", records/CPU:" + DefaultCacheAccess.this.recordsPerCPU + "]";
        }
    }
}

