/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexReader;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.TextDocumentStructure;
import org.neo4j.kernel.api.impl.schema.reader.CypherStringQueryFactory;
import org.neo4j.kernel.api.impl.schema.sampler.LuceneIndexSampler;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.values.storable.Value;

public class TextIndexReader
extends AbstractTextIndexReader {
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public TextIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator, IndexUsageTracking usageTracker) {
        super(descriptor, searcherReference, usageTracker);
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        return new LuceneIndexSampler(this.getIndexSearcher(), this.taskCoordinator, this.samplingConfig);
    }

    @Override
    protected Query toLuceneQuery(PropertyIndexQuery predicate, IndexQueryConstraints constraints) {
        return switch (predicate.type()) {
            case IndexQuery.IndexQueryType.ALL_ENTRIES -> TextDocumentStructure.newScanQuery();
            case IndexQuery.IndexQueryType.EXACT -> TextDocumentStructure.newSeekQuery(((PropertyIndexQuery.ExactPredicate)predicate).value());
            case IndexQuery.IndexQueryType.STRING_PREFIX -> {
                PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                yield CypherStringQueryFactory.stringPrefix(spp.prefix().stringValue());
            }
            case IndexQuery.IndexQueryType.STRING_CONTAINS -> {
                PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                yield CypherStringQueryFactory.stringContains(scp.contains().stringValue());
            }
            case IndexQuery.IndexQueryType.STRING_SUFFIX -> {
                PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                yield CypherStringQueryFactory.stringSuffix(ssp.suffix().stringValue());
            }
            default -> throw this.invalidQuery(IllegalArgumentException::new, predicate);
        };
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return false;
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        TermQuery entityIdQuery = new TermQuery(TextDocumentStructure.newTermForChangeOrRemove(entityId));
        Query valueQuery = TextDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder entityIdAndValueQuery = new BooleanQuery.Builder();
        entityIdAndValueQuery.add((Query)entityIdQuery, BooleanClause.Occur.MUST);
        entityIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)entityIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

