/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.WriteOperations;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LazyPropertyKey;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LazyPropertyKey$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.SetOperation;
import org.neo4j.cypher.internal.runtime.makeValueNeoSafe$;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra!\u0002\u0003\u0006\u0003\u0003!\u0002\"B\u0010\u0001\t\u0003\u0001\u0003\"\u0002\u0012\u0001\t#\u0019\u0003\"\u00025\u0001\t#I'\u0001H!cgR\u0014\u0018m\u0019;TKR\u0004&o\u001c9feRLx\n]3sCRLwN\u001c\u0006\u0003\r\u001d\tQ\u0001]5qKNT!\u0001C\u0005\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003\u0015-\tqA];oi&lWM\u0003\u0002\r\u001b\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000f\u001f\u000511-\u001f9iKJT!\u0001E\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u000b%\u0011a$\u0002\u0002\r'\u0016$x\n]3sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"\u0001\b\u0001\u0002\u0017M,G\u000f\u0015:pa\u0016\u0014H/_\u000b\u0003Im\"\u0002\"\n\u0015/g\u001dc\u0015L\u0018\t\u0003-\u0019J!aJ\f\u0003\u000f\t{w\u000e\\3b]\")\u0011F\u0001a\u0001U\u000591m\u001c8uKb$\bCA\u0016-\u001b\u0005I\u0011BA\u0017\n\u0005%\u0019\u0015\u0010\u001d5feJ{w\u000fC\u00030\u0005\u0001\u0007\u0001'A\u0003ti\u0006$X\r\u0005\u0002\u001dc%\u0011!'\u0002\u0002\u000b#V,'/_*uCR,\u0007\"\u0002\u001b\u0003\u0001\u0004)\u0014aA8qgB\u0012a'\u0012\t\u0005W]JD)\u0003\u00029\u0013\tyqK]5uK>\u0003XM]1uS>t7\u000f\u0005\u0002;w1\u0001A!\u0002\u001f\u0003\u0005\u0004i$!\u0001+\u0012\u0005y\n\u0005C\u0001\f@\u0013\t\u0001uCA\u0004O_RD\u0017N\\4\u0011\u0005Y\u0011\u0015BA\"\u0018\u0005\r\te.\u001f\t\u0003u\u0015#\u0011BR\u001a\u0002\u0002\u0003\u0005)\u0011A\u001f\u0003\u0007}#\u0013\u0007C\u0003I\u0005\u0001\u0007\u0011*\u0001\u0004ji\u0016l\u0017\n\u001a\t\u0003-)K!aS\f\u0003\t1{gn\u001a\u0005\u0006\u001b\n\u0001\rAT\u0001\u0010aJ|\u0007/\u001a:us.+\u0017PT1nKB\u0011qJ\u0016\b\u0003!R\u0003\"!U\f\u000e\u0003IS!aU\n\u0002\rq\u0012xn\u001c;?\u0013\t)v#\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u0018\u0011\u0015Q&\u00011\u0001\\\u0003Ai\u0017-\u001f2f!J|\u0007/\u001a:us.+\u0017\u0010\u0005\u0002\u00179&\u0011Ql\u0006\u0002\u0004\u0013:$\b\"B0\u0003\u0001\u0004\u0001\u0017AC3yaJ,7o]5p]B\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002f\u000f\u0005A1m\\7nC:$7/\u0003\u0002hE\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001bM,G\u000f\u0015:pa\u0016\u0014H/[3t+\tQ\u0017\u000fF\u0004JW2lWO\u001e@\t\u000b%\u001a\u0001\u0019\u0001\u0016\t\u000b=\u001a\u0001\u0019\u0001\u0019\t\u000bQ\u001a\u0001\u0019\u000181\u0005=\u001c\b\u0003B\u00168aJ\u0004\"AO9\u0005\u000bq\u001a!\u0019A\u001f\u0011\u0005i\u001aH!\u0003;n\u0003\u0003\u0005\tQ!\u0001>\u0005\ryFE\r\u0005\u0006\u0011\u000e\u0001\r!\u0013\u0005\u0006o\u000e\u0001\r\u0001_\u0001\u0005W\u0016L8\u000fE\u0002\u0017snL!A_\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005qa\u0018BA?\u0006\u0005=a\u0015M_=Qe>\u0004XM\u001d;z\u0017\u0016L\bBB@\u0004\u0001\u0004\t\t!\u0001\u0004wC2,Xm\u001d\t\u0004-e\u0004\u0007")
public abstract class AbstractSetPropertyOperation
implements SetOperation {
    @Override
    public void execute(CypherRow row, QueryState state) {
        SetOperation.execute$(this, row, state);
    }

    public <T> boolean setProperty(CypherRow context, QueryState state, WriteOperations<T, ?> ops, long itemId, String propertyKeyName, int maybePropertyKey, Expression expression) {
        QueryContext queryContext = state.query();
        Value value = makeValueNeoSafe$.MODULE$.apply(expression.apply((ReadableRow)context, state));
        if (value == Values.NO_VALUE) {
            if (maybePropertyKey != LazyPropertyKey$.MODULE$.UNKNOWN()) {
                return ops.removeProperty(itemId, maybePropertyKey);
            }
            return false;
        }
        int propertyId = maybePropertyKey == LazyPropertyKey$.MODULE$.UNKNOWN() ? queryContext.getOrCreatePropertyKeyId(propertyKeyName) : maybePropertyKey;
        ops.setProperty(itemId, propertyId, value);
        return true;
    }

    public <T> long setProperties(CypherRow context, QueryState state, WriteOperations<T, ?> ops, long itemId, LazyPropertyKey[] keys, Expression[] values) {
        QueryContext queryContext = state.query();
        MutableIntObjectMap propValues = IntObjectMaps.mutable.empty();
        for (int i = 0; i < keys.length; ++i) {
            Object object;
            LazyPropertyKey propertyKey = keys[i];
            Expression expression = values[i];
            int maybePropertyKey = propertyKey.id((ReadTokenContext)queryContext);
            Value value = makeValueNeoSafe$.MODULE$.apply(expression.apply((ReadableRow)context, state));
            if (value == Values.NO_VALUE) {
                if (maybePropertyKey != LazyPropertyKey$.MODULE$.UNKNOWN()) {
                    object = propValues.put(maybePropertyKey, (Object)Values.NO_VALUE);
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            int propertyId = maybePropertyKey == LazyPropertyKey$.MODULE$.UNKNOWN() ? queryContext.getOrCreatePropertyKeyId(propertyKey.name()) : maybePropertyKey;
            object = propValues.put(propertyId, (Object)value);
        }
        ops.setProperties(itemId, (IntObjectMap)propValues);
        return propValues.size();
    }

    public AbstractSetPropertyOperation() {
        SetOperation.$init$(this);
    }
}

