/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;

public class TransactionListenersState {
    private final TransactionData txData;
    private final List<ListenerState<?>> states = new ArrayList();
    private Throwable error;

    TransactionListenersState(TransactionData txData) {
        this.txData = txData;
    }

    public void failed(Throwable error) {
        this.error = error;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public Throwable failure() {
        return this.error;
    }

    void addListenerState(TransactionEventListener<?> handler, Object state) {
        this.states.add(new ListenerState<Object>(handler, state));
    }

    TransactionData getTxData() {
        return this.txData;
    }

    public List<ListenerState<?>> getStates() {
        return this.states;
    }

    record ListenerState<T>(TransactionEventListener<T> listener, T state) {
    }
}

