/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.Serializable;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntLongHashMap;

public class CountsDelta {
    private static final long DEFAULT_COUNT = 0L;
    protected final IntLongHashMap nodeCounts = new IntLongHashMap();
    protected final MutableMap<RelationshipKey, MutableLong> relationshipCounts = UnifiedMap.newMap();

    public long nodeCount(int labelId) {
        return this.nodeCounts.getIfAbsent(labelId, 0L);
    }

    public void incrementNodeCount(int labelId, long delta) {
        if (delta != 0L) {
            this.internalIncrementNodeCount(labelId, delta);
        }
    }

    public void incrementNodeCount(int[] labelIds, long delta) {
        if (delta != 0L) {
            for (int labelId : labelIds) {
                this.internalIncrementNodeCount(labelId, delta);
            }
        }
    }

    private void internalIncrementNodeCount(int labelId, long delta) {
        this.nodeCounts.updateValue(labelId, 0L, (LongToLongFunction & Serializable)l -> l + delta);
    }

    public long relationshipCount(int startLabelId, int typeId, int endLabelId) {
        RelationshipKey relationshipKey = new RelationshipKey(startLabelId, typeId, endLabelId);
        MutableLong counts = (MutableLong)this.relationshipCounts.get((Object)relationshipKey);
        return counts == null ? 0L : counts.longValue();
    }

    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        if (delta != 0L) {
            RelationshipKey relationshipKey = new RelationshipKey(startLabelId, typeId, endLabelId);
            ((MutableLong)this.relationshipCounts.getIfAbsentPutWithKey((Object)relationshipKey, (Function & Serializable)k -> new MutableLong(0L))).add(delta);
        }
    }

    public void incrementRelationshipCountsForLabelChange(int typeId, int labelId, long outgoing, long incoming) {
        this.incrementRelationshipCount(labelId, -1, -1, outgoing);
        this.incrementRelationshipCount(-1, -1, labelId, incoming);
        this.incrementRelationshipCount(labelId, typeId, -1, outgoing);
        this.incrementRelationshipCount(-1, typeId, labelId, incoming);
    }

    public void accept(Visitor visitor) {
        this.nodeCounts.forEachKeyValue(visitor::visitNodeCount);
        this.relationshipCounts.forEachKeyValue((Procedure2 & Serializable)(k, count) -> visitor.visitRelationshipCount(k.startLabelId, k.typeId, k.endLabelId, count.longValue()));
    }

    public boolean hasChanges() {
        return !this.nodeCounts.isEmpty() || !this.relationshipCounts.isEmpty();
    }

    public int size() {
        return this.nodeCounts.size() + this.relationshipCounts.size();
    }

    public void clear() {
        this.nodeCounts.clear();
        this.relationshipCounts.clear();
    }

    public record RelationshipKey(int startLabelId, int typeId, int endLabelId) {
    }

    public static interface Visitor {
        public void visitNodeCount(int var1, long var2);

        public void visitRelationshipCount(int var1, int var2, int var3, long var4);
    }
}

