/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class IndexEntryConflictException
extends KernelException {
    private final SchemaDescriptor schemaDescriptor;
    private final ValueTuple propertyValues;
    private final long addedEntityId;
    private final long existingEntityId;

    public IndexEntryConflictException(SchemaDescriptor schemaDescriptor, long existingEntityId, long addedEntityId, Value ... propertyValue) {
        this(schemaDescriptor, existingEntityId, addedEntityId, ValueTuple.of((Value[])propertyValue));
    }

    public IndexEntryConflictException(ErrorGqlStatusObject gqlStatusObject, SchemaDescriptor schemaDescriptor, long existingEntityId, long addedEntityId, Value ... propertyValue) {
        this(gqlStatusObject, schemaDescriptor, existingEntityId, addedEntityId, ValueTuple.of((Value[])propertyValue));
    }

    public IndexEntryConflictException(SchemaDescriptor schemaDescriptor, long existingEntityId, long addedEntityId, ValueTuple propertyValues) {
        super((Status)Status.Schema.ConstraintViolation, IndexEntryConflictException.buildErrorMessage(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, schemaDescriptor, propertyValues, addedEntityId, existingEntityId), new Object[0]);
        this.schemaDescriptor = schemaDescriptor;
        this.existingEntityId = existingEntityId;
        this.addedEntityId = addedEntityId;
        this.propertyValues = propertyValues;
    }

    public IndexEntryConflictException(ErrorGqlStatusObject gqlStatusObject, SchemaDescriptor schemaDescriptor, long existingEntityId, long addedEntityId, ValueTuple propertyValues) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintViolation, IndexEntryConflictException.buildErrorMessage(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, schemaDescriptor, propertyValues, addedEntityId, existingEntityId), new Object[0]);
        this.schemaDescriptor = schemaDescriptor;
        this.existingEntityId = existingEntityId;
        this.addedEntityId = addedEntityId;
        this.propertyValues = propertyValues;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return IndexEntryConflictException.buildErrorMessage(tokenNameLookup, this.schemaDescriptor, this.propertyValues, this.addedEntityId, this.existingEntityId);
    }

    private static String buildErrorMessage(TokenNameLookup tokenNameLookup, SchemaDescriptor schemaDescriptor, ValueTuple propertyValues, long addedEntityId, long existingEntityId) {
        String tokenName;
        String entityName;
        assert (schemaDescriptor.getPropertyIds().length == propertyValues.size());
        if (schemaDescriptor.entityType() == EntityType.NODE) {
            entityName = "Node";
            tokenName = Arrays.stream(schemaDescriptor.getEntityTokenIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0)).collect(Collectors.joining("`, `", "label `", "`"));
        } else {
            entityName = "Relationship";
            tokenName = Arrays.stream(schemaDescriptor.getEntityTokenIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0)).collect(Collectors.joining("`, `", "type `", "`"));
        }
        if (existingEntityId == -1L && addedEntityId == -1L) {
            return String.format("A %s already exists with %s and %s", entityName, tokenName, IndexEntryConflictException.propertyString(tokenNameLookup, schemaDescriptor.getPropertyIds(), propertyValues));
        }
        if (addedEntityId == -1L) {
            return String.format("%s(%d) already exists with %s and %s", entityName, existingEntityId, tokenName, IndexEntryConflictException.propertyString(tokenNameLookup, schemaDescriptor.getPropertyIds(), propertyValues));
        }
        if (existingEntityId == -1L) {
            return String.format("Both another %s and %s(%d) have the %s and %s", entityName, entityName, addedEntityId, tokenName, IndexEntryConflictException.propertyString(tokenNameLookup, schemaDescriptor.getPropertyIds(), propertyValues));
        }
        return String.format("Both %s(%d) and %s(%d) have the %s and %s", entityName, existingEntityId, entityName, addedEntityId, tokenName, IndexEntryConflictException.propertyString(tokenNameLookup, schemaDescriptor.getPropertyIds(), propertyValues));
    }

    @VisibleForTesting
    public ValueTuple getPropertyValues() {
        return this.propertyValues;
    }

    @VisibleForTesting
    public long getAddedEntityId() {
        return this.addedEntityId;
    }

    @VisibleForTesting
    public long getExistingEntityId() {
        return this.existingEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IndexEntryConflictException) {
            IndexEntryConflictException that = (IndexEntryConflictException)((Object)o);
            return this.addedEntityId == that.addedEntityId && this.existingEntityId == that.existingEntityId && Objects.equals(this.propertyValues, that.propertyValues);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.addedEntityId, this.existingEntityId, this.propertyValues);
    }

    public String toString() {
        return "IndexEntryConflictException{propertyValues=" + this.propertyValues + ", addedEntityId=" + this.addedEntityId + ", existingEntityId=" + this.existingEntityId + "}";
    }

    private static String propertyString(TokenNameLookup tokenNameLookup, int[] propertyIds, ValueTuple propertyValues) {
        StringBuilder sb = new StringBuilder();
        String sep = propertyIds.length > 1 ? "properties " : "property ";
        for (int i = 0; i < propertyIds.length; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append('`');
            sb.append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
            sb.append("` = ");
            sb.append(propertyValues.valueAt(i).prettyPrint());
        }
        return sb.toString();
    }
}

