/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.Source;

public class AutoReadingSource
implements Source {
    private final CharReadable reader;
    private SectionedCharBuffer charBuffer;

    public AutoReadingSource(CharReadable reader, int bufferSize) {
        this(reader, new SectionedCharBuffer(bufferSize));
    }

    public AutoReadingSource(CharReadable reader, SectionedCharBuffer charBuffer) {
        this.reader = reader;
        this.charBuffer = charBuffer;
    }

    @Override
    public Source.Chunk nextChunk(int seekStartPos) throws IOException {
        this.charBuffer = this.reader.read(this.charBuffer, seekStartPos == -1 ? this.charBuffer.pivot() : seekStartPos);
        return new Source.GivenChunk(this.charBuffer.array(), this.charBuffer.available(), this.charBuffer.pivot(), this.reader.sourceDescription(), this.charBuffer.pivot(), this.charBuffer.back());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

