# Metasploit auto auxiliary script (msfenum)

Msfenum simplifies running multiple auxiliary modules on a specific set of targets. Running a low hanging fruit scan within a penetration test can be very useful, for example to find open shares or vulnerable services quickly. 

The Metasploit framework offers lots of useful auxiliary modules to perform low hanging fruit scans. This script simply runs all the auxiliary modules specified in the config files against the specified targets. All settings can be modified per auxiliary module and new modules can be added easily.

Feel free to share your useful auxiliary configuration for low hanging fruit scans or any code improvements :).

## Usage

Modify the "config" file. Change the CHANGEME values in the "settings" key, otherwise those modules will not run.

``python msfenum.py [-h] [-t [THREADS]] [-p [PROJECT]] TARGET_FILE``

  -t [THREADS], Number of threads
  
  -p [PROJECT], Project name

## Structure:
* logs/
  * Contains all results after running the script
* modules/
  * Contains all configuration per auxiliary module
* config
  * Contains global configuration settings
* msfenum.log
  * Some logging generated when running msfenum.py
* msfenum.py
  * The main script

## Result example

All raw results generated by Metasploit are stored within seperate files in the "logs/" directory. If you specified a project name, this name is used as a folder name. Otherwise, the current unix timestamp is used. After running the script, a summary is printed to get an overview of succesfull findings:

![alt text](https://forsec.nl/wp-content/uploads/2018/07/msfenum_results.png)
