/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.Counters$AbstractPathCounters;
import org.apache.commons.io.file.Counters$LongCounter;
import org.apache.commons.io.file.Counters$LongPathCounters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.function.IOBiFunction;

public final class DeletingPathVisitor
extends SimpleFileVisitor
implements FileVisitor {
    public final IOBiFunction visitFileFailedFunction;
    public final Counters$PathCounters pathCounters;
    public final PathFilter dirFilter;
    public final String[] skip;
    public final boolean overrideReadOnly;
    public final LinkOption[] linkOptions;

    public DeletingPathVisitor(Counters$LongPathCounters linkOptionArray, LinkOption[] linkOptionArray2, DeleteOption[] deleteOptionArray, String ... stringArray) {
        DeletingPathVisitor deletingPathVisitor = this;
        Counters$LongPathCounters counters$LongPathCounters = linkOptionArray;
        new SymbolicLinkFileFilter;
        linkOptionArray = TrueFileFilter.INSTANCE;
        this();
        deletingPathVisitor.pathCounters = counters$LongPathCounters;
        deletingPathVisitor.dirFilter = linkOptionArray;
        Object[] objectArray = (String[])stringArray.clone();
        Arrays.sort(objectArray);
        this.skip = objectArray;
        this.overrideReadOnly = StandardDeleteOption.overrideReadOnly((DeleteOption[])deleteOptionArray);
        linkOptionArray = linkOptionArray2 == null ? PathUtils.noFollowLinkOptionArray() : (LinkOption[])linkOptionArray2.clone();
        this.linkOptions = linkOptionArray;
    }

    public DeletingPathVisitor() {
        DeletingPathVisitor deletingPathVisitor = this;
        deletingPathVisitor.visitFileFailedFunction = (object, iOException) -> super.visitFileFailed(object, (IOException)iOException);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.equals$org$apache$commons$io$file$CountingPathVisitor(object)) {
            return false;
        }
        if (DeletingPathVisitor.class != object.getClass()) {
            return false;
        }
        object = (DeletingPathVisitor)object;
        return this.overrideReadOnly == ((DeletingPathVisitor)object).overrideReadOnly && Arrays.equals(this.skip, ((DeletingPathVisitor)object).skip);
    }

    public final int hashCode() {
        DeletingPathVisitor deletingPathVisitor = this;
        Object object = deletingPathVisitor.pathCounters;
        int n = (Objects.hash(object) * 31 + Arrays.hashCode(this.skip)) * 31;
        object = deletingPathVisitor.overrideReadOnly;
        return Objects.hash(object) + n;
    }

    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (Arrays.binarySearch(this.skip, PathUtils.getFileNameString(path)) < 0) {
            if (Files.exists(path, this.linkOptions)) {
                if (this.overrideReadOnly) {
                    PathUtils.setReadOnly(path, this.linkOptions);
                }
                Files.deleteIfExists(path);
            }
            if (Files.isSymbolicLink(path)) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {}
            }
        }
        Counters$AbstractPathCounters counters$AbstractPathCounters = (Counters$AbstractPathCounters)this.pathCounters;
        ++((Counters$LongCounter)counters$AbstractPathCounters.fileCounter).value;
        long l = basicFileAttributes.size();
        ((Counters$LongCounter)counters$AbstractPathCounters.byteCounter).value += l;
        return FileVisitResult.CONTINUE;
    }

    public final FileVisitResult postVisitDirectory(Object object, IOException object2) {
        boolean bl;
        object = (Path)object;
        object2 = Files.newDirectoryStream((Path)object);
        try {
            bl = object2.iterator().hasNext() ^ true;
        }
        catch (Throwable throwable) {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        object2.close();
        if (bl) {
            Files.deleteIfExists((Path)object);
        }
        ++((Counters$LongCounter)((Counters$AbstractPathCounters)this.pathCounters).directoryCounter).value;
        return FileVisitResult.CONTINUE;
    }

    public final FileVisitResult preVisitDirectory(Object object, BasicFileAttributes object2) {
        object = (Path)object;
        object2 = FileVisitResult.CONTINUE;
        if (this.dirFilter.accept((Path)object) != object2) {
        }
        if (Arrays.binarySearch(this.skip, PathUtils.getFileNameString((Path)object)) >= 0) {
            object2 = FileVisitResult.SKIP_SUBTREE;
        }
        return object2;
    }

    public final boolean equals$org$apache$commons$io$file$CountingPathVisitor(Object object) {
        if (deletingPathVisitor2 == object) {
            return true;
        }
        if (!(object instanceof DeletingPathVisitor)) {
            return false;
        }
        DeletingPathVisitor deletingPathVisitor = deletingPathVisitor2;
        DeletingPathVisitor deletingPathVisitor2 = (DeletingPathVisitor)object;
        return Objects.equals(deletingPathVisitor.pathCounters, deletingPathVisitor2.pathCounters);
    }

    public final String toString() {
        return this.pathCounters.toString();
    }

    public final FileVisitResult visitFileFailed(Object object, IOException iOException) {
        DeletingPathVisitor deletingPathVisitor = path;
        Path path = (Path)object;
        return (FileVisitResult)((Object)deletingPathVisitor.visitFileFailedFunction.apply(path, iOException));
    }
}

