/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.dnd;

import com.sun.jna.platform.dnd.DragHandler;
import com.sun.jna.platform.dnd.DropTargetPainter;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DropHandler
implements DropTargetListener {
    private static final Logger LOG = Logger.getLogger(DropHandler.class.getName());
    private int acceptedActions;
    private List<DataFlavor> acceptedFlavors;
    private DropTarget dropTarget;
    private boolean active = true;
    private DropTargetPainter painter;
    private String lastAction;

    public DropHandler(Component c11, int acceptedActions) {
        this(c11, acceptedActions, new DataFlavor[0]);
    }

    public DropHandler(Component c11, int acceptedActions, DataFlavor[] acceptedFlavors) {
        this(c11, acceptedActions, acceptedFlavors, null);
    }

    public DropHandler(Component c11, int acceptedActions, DataFlavor[] acceptedFlavors, DropTargetPainter painter) {
        this.acceptedActions = acceptedActions;
        this.acceptedFlavors = Arrays.asList(acceptedFlavors);
        this.painter = painter;
        this.dropTarget = new DropTarget(c11, acceptedActions, this, this.active);
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.dropTarget != null) {
            this.dropTarget.setActive(active);
        }
    }

    protected int getDropActionsForFlavors(DataFlavor[] dataFlavors) {
        return this.acceptedActions;
    }

    protected int getDropAction(DropTargetEvent e11) {
        int availableActions;
        DropTargetEvent ev2;
        int currentAction = 0;
        int sourceActions = 0;
        Point location = null;
        DataFlavor[] flavors = new DataFlavor[]{};
        if (e11 instanceof DropTargetDragEvent) {
            ev2 = (DropTargetDragEvent)e11;
            currentAction = ((DropTargetDragEvent)ev2).getDropAction();
            sourceActions = ((DropTargetDragEvent)ev2).getSourceActions();
            flavors = ((DropTargetDragEvent)ev2).getCurrentDataFlavors();
            location = ((DropTargetDragEvent)ev2).getLocation();
        } else if (e11 instanceof DropTargetDropEvent) {
            ev2 = (DropTargetDropEvent)e11;
            currentAction = ((DropTargetDropEvent)ev2).getDropAction();
            sourceActions = ((DropTargetDropEvent)ev2).getSourceActions();
            flavors = ((DropTargetDropEvent)ev2).getCurrentDataFlavors();
            location = ((DropTargetDropEvent)ev2).getLocation();
        }
        if (this.isSupported(flavors) && (currentAction = this.getDropAction(e11, currentAction, sourceActions, availableActions = this.getDropActionsForFlavors(flavors))) != 0 && this.canDrop(e11, currentAction, location)) {
            return currentAction;
        }
        return 0;
    }

    protected int getDropAction(DropTargetEvent e11, int currentAction, int sourceActions, int acceptedActions) {
        int action;
        boolean modifiersActive = this.modifiersActive(currentAction);
        if ((currentAction & acceptedActions) == 0 && !modifiersActive) {
            int action2;
            currentAction = action2 = acceptedActions & sourceActions;
        } else if (modifiersActive && (action = currentAction & acceptedActions & sourceActions) != currentAction) {
            currentAction = action;
        }
        return currentAction;
    }

    protected boolean modifiersActive(int dropAction) {
        int mods = DragHandler.getModifiers();
        if (mods == -1) {
            return dropAction == 0x40000000 || dropAction == 1;
        }
        return mods != 0;
    }

    private void describe(String type, DropTargetEvent e11) {
        if (LOG.isLoggable(Level.FINE)) {
            DropTargetContext dtc;
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("drop: ");
            msgBuilder.append(type);
            if (e11 instanceof DropTargetDragEvent) {
                dtc = e11.getDropTargetContext();
                DropTarget dt2 = dtc.getDropTarget();
                DropTargetDragEvent ev2 = (DropTargetDragEvent)e11;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(ev2.getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(dt2.getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(ev2.getDropAction()));
            } else if (e11 instanceof DropTargetDropEvent) {
                dtc = e11.getDropTargetContext();
                DropTarget dt3 = dtc.getDropTarget();
                DropTargetDropEvent ev3 = (DropTargetDropEvent)e11;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(ev3.getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(dt3.getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(ev3.getDropAction()));
            }
            String msg = msgBuilder.toString();
            if (!msg.equals(this.lastAction)) {
                LOG.log(Level.FINE, msg);
                this.lastAction = msg;
            }
        }
    }

    protected int acceptOrReject(DropTargetDragEvent e11) {
        int action = this.getDropAction(e11);
        if (action != 0) {
            e11.acceptDrag(action);
        } else {
            e11.rejectDrag();
        }
        return action;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e11) {
        this.describe("enter(tgt)", e11);
        int action = this.acceptOrReject(e11);
        this.paintDropTarget(e11, action, e11.getLocation());
    }

    @Override
    public void dragOver(DropTargetDragEvent e11) {
        this.describe("over(tgt)", e11);
        int action = this.acceptOrReject(e11);
        this.paintDropTarget(e11, action, e11.getLocation());
    }

    @Override
    public void dragExit(DropTargetEvent e11) {
        this.describe("exit(tgt)", e11);
        this.paintDropTarget(e11, 0, null);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e11) {
        this.describe("change(tgt)", e11);
        int action = this.acceptOrReject(e11);
        this.paintDropTarget(e11, action, e11.getLocation());
    }

    @Override
    public void drop(DropTargetDropEvent e11) {
        this.describe("drop(tgt)", e11);
        int action = this.getDropAction(e11);
        if (action != 0) {
            e11.acceptDrop(action);
            try {
                this.drop(e11, action);
                e11.dropComplete(true);
            }
            catch (Exception ex2) {
                e11.dropComplete(false);
            }
        } else {
            e11.rejectDrop();
        }
        this.paintDropTarget(e11, 0, e11.getLocation());
    }

    protected boolean isSupported(DataFlavor[] flavors) {
        HashSet<DataFlavor> set = new HashSet<DataFlavor>(Arrays.asList(flavors));
        set.retainAll(this.acceptedFlavors);
        return !set.isEmpty();
    }

    protected void paintDropTarget(DropTargetEvent e11, int action, Point location) {
        if (this.painter != null) {
            this.painter.paintDropTarget(e11, action, location);
        }
    }

    protected boolean canDrop(DropTargetEvent e11, int action, Point location) {
        return true;
    }

    protected abstract void drop(DropTargetDropEvent var1, int var2) throws UnsupportedFlavorException, IOException;
}

