/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class TraceUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);

    public static String getCurrentStack() {
        return TraceUtils.getCurrentStack(1);
    }

    public static String getCurrentStack(int numberOfTopFramesToRemove) {
        int pos;
        String fullStack = TraceUtils.getStackTrace(new Throwable(){

            @Override
            public String toString() {
                return "";
            }
        });
        int start = 0;
        if (numberOfTopFramesToRemove < 0) {
            numberOfTopFramesToRemove = 0;
        }
        for (int i11 = 0; i11 < numberOfTopFramesToRemove + 2 && (pos = fullStack.indexOf(10, start)) >= 0; ++i11) {
            start = pos + 1;
        }
        return fullStack.substring(start);
    }

    public static String getStackTrace(Throwable t11) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            t11.printStackTrace(writer);
            String string = stringWriter.toString();
            return string;
        }
    }

    public static String getStacksOfAllThreads() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            StackTraceElement[] stackTrace;
            if (buf.length() != 0) {
                buf.append('\n');
            }
            Thread thread2 = entry.getKey();
            buf.append(thread2.toString());
            buf.append('\n');
            for (StackTraceElement frame : stackTrace = entry.getValue()) {
                buf.append("  at ");
                buf.append(frame.toString());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public static String getSimpleId(Object obj) {
        return obj == null ? "null" : String.format("%s@%08X", obj.getClass().getSimpleName(), System.identityHashCode(obj));
    }

    public static String getSimpleIds(Iterable<?> iterable) {
        StringBuilder result = new StringBuilder();
        for (Object element : iterable) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(TraceUtils.getSimpleId(element));
        }
        return result.toString();
    }

    public static String currentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private TraceUtils() {
    }
}

