/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.tools.build.bundletool.commands.AddTransparencyCommand;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;

final class AutoValue_AddTransparencyCommand
extends AddTransparencyCommand {
    private final AddTransparencyCommand.Mode mode;
    private final Path bundlePath;
    private final Path outputPath;
    private final AddTransparencyCommand.DexMergingChoice dexMergingChoice;
    private final Optional<SignerConfig> signerConfig;
    private final ImmutableList<X509Certificate> transparencyKeyCertificates;
    private final Optional<Path> transparencySignaturePath;
    private final Optional<Boolean> allowSharedUserId;

    private AutoValue_AddTransparencyCommand(AddTransparencyCommand.Mode mode, Path bundlePath, Path outputPath, AddTransparencyCommand.DexMergingChoice dexMergingChoice, Optional<SignerConfig> signerConfig, ImmutableList<X509Certificate> transparencyKeyCertificates, Optional<Path> transparencySignaturePath, Optional<Boolean> allowSharedUserId) {
        this.mode = mode;
        this.bundlePath = bundlePath;
        this.outputPath = outputPath;
        this.dexMergingChoice = dexMergingChoice;
        this.signerConfig = signerConfig;
        this.transparencyKeyCertificates = transparencyKeyCertificates;
        this.transparencySignaturePath = transparencySignaturePath;
        this.allowSharedUserId = allowSharedUserId;
    }

    @Override
    public AddTransparencyCommand.Mode getMode() {
        return this.mode;
    }

    @Override
    public Path getBundlePath() {
        return this.bundlePath;
    }

    @Override
    public Path getOutputPath() {
        return this.outputPath;
    }

    @Override
    public AddTransparencyCommand.DexMergingChoice getDexMergingChoice() {
        return this.dexMergingChoice;
    }

    @Override
    public Optional<SignerConfig> getSignerConfig() {
        return this.signerConfig;
    }

    @Override
    public ImmutableList<X509Certificate> getTransparencyKeyCertificates() {
        return this.transparencyKeyCertificates;
    }

    @Override
    public Optional<Path> getTransparencySignaturePath() {
        return this.transparencySignaturePath;
    }

    @Override
    public Optional<Boolean> getAllowSharedUserId() {
        return this.allowSharedUserId;
    }

    public String toString() {
        return "AddTransparencyCommand{mode=" + (Object)((Object)this.mode) + ", bundlePath=" + this.bundlePath + ", outputPath=" + this.outputPath + ", dexMergingChoice=" + (Object)((Object)this.dexMergingChoice) + ", signerConfig=" + this.signerConfig + ", transparencyKeyCertificates=" + this.transparencyKeyCertificates + ", transparencySignaturePath=" + this.transparencySignaturePath + ", allowSharedUserId=" + this.allowSharedUserId + "}";
    }

    public boolean equals(Object o11) {
        if (o11 == this) {
            return true;
        }
        if (o11 instanceof AddTransparencyCommand) {
            AddTransparencyCommand that = (AddTransparencyCommand)o11;
            return this.mode.equals((Object)that.getMode()) && this.bundlePath.equals(that.getBundlePath()) && this.outputPath.equals(that.getOutputPath()) && this.dexMergingChoice.equals((Object)that.getDexMergingChoice()) && this.signerConfig.equals(that.getSignerConfig()) && this.transparencyKeyCertificates.equals(that.getTransparencyKeyCertificates()) && this.transparencySignaturePath.equals(that.getTransparencySignaturePath()) && this.allowSharedUserId.equals(that.getAllowSharedUserId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mode.hashCode();
        h$ *= 1000003;
        h$ ^= this.bundlePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.dexMergingChoice.hashCode();
        h$ *= 1000003;
        h$ ^= this.signerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.transparencyKeyCertificates.hashCode();
        h$ *= 1000003;
        h$ ^= this.transparencySignaturePath.hashCode();
        h$ *= 1000003;
        return h$ ^= this.allowSharedUserId.hashCode();
    }

    static final class Builder
    extends AddTransparencyCommand.Builder {
        private AddTransparencyCommand.Mode mode;
        private Path bundlePath;
        private Path outputPath;
        private AddTransparencyCommand.DexMergingChoice dexMergingChoice;
        private Optional<SignerConfig> signerConfig = Optional.empty();
        private ImmutableList<X509Certificate> transparencyKeyCertificates;
        private Optional<Path> transparencySignaturePath = Optional.empty();
        private Optional<Boolean> allowSharedUserId = Optional.empty();

        Builder() {
        }

        @Override
        public AddTransparencyCommand.Builder setMode(AddTransparencyCommand.Mode mode) {
            if (mode == null) {
                throw new NullPointerException("Null mode");
            }
            this.mode = mode;
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setBundlePath(Path bundlePath) {
            if (bundlePath == null) {
                throw new NullPointerException("Null bundlePath");
            }
            this.bundlePath = bundlePath;
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setOutputPath(Path outputPath) {
            if (outputPath == null) {
                throw new NullPointerException("Null outputPath");
            }
            this.outputPath = outputPath;
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setDexMergingChoice(AddTransparencyCommand.DexMergingChoice dexMergingChoice) {
            if (dexMergingChoice == null) {
                throw new NullPointerException("Null dexMergingChoice");
            }
            this.dexMergingChoice = dexMergingChoice;
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setSignerConfig(SignerConfig signerConfig) {
            this.signerConfig = Optional.of(signerConfig);
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setTransparencyKeyCertificates(List<X509Certificate> transparencyKeyCertificates) {
            this.transparencyKeyCertificates = ImmutableList.copyOf(transparencyKeyCertificates);
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setTransparencySignaturePath(Path transparencySignaturePath) {
            this.transparencySignaturePath = Optional.of(transparencySignaturePath);
            return this;
        }

        @Override
        public AddTransparencyCommand.Builder setAllowSharedUserId(Boolean allowSharedUserId) {
            this.allowSharedUserId = Optional.of(allowSharedUserId);
            return this;
        }

        @Override
        public AddTransparencyCommand build() {
            String missing = "";
            if (this.mode == null) {
                missing = missing + " mode";
            }
            if (this.bundlePath == null) {
                missing = missing + " bundlePath";
            }
            if (this.outputPath == null) {
                missing = missing + " outputPath";
            }
            if (this.dexMergingChoice == null) {
                missing = missing + " dexMergingChoice";
            }
            if (this.transparencyKeyCertificates == null) {
                missing = missing + " transparencyKeyCertificates";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AddTransparencyCommand(this.mode, this.bundlePath, this.outputPath, this.dexMergingChoice, this.signerConfig, this.transparencyKeyCertificates, this.transparencySignaturePath, this.allowSharedUserId);
        }
    }
}

