/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import rcm.awt.Constrain;
import rcm.awt.PopupDialog;
import rcm.util.Win;
import websphinx.workbench.WebGraph;
import websphinx.workbench.WebOutline;

public class WorkbenchControlPanel
extends PopupDialog {
    WebGraph g;
    WebOutline o;
    Choice nodeChoice;
    Choice pageChoice;
    Choice linkChoice;
    Checkbox automatic;
    Button applyButton;
    Button okButton;
    Button cancelButton;

    public WorkbenchControlPanel(WebGraph g, WebOutline o) {
        super((Component)Win.findFrame(g != null ? g : o), "Workbench Control Panel", true);
        this.g = g;
        this.o = o;
        this.setLayout(new GridBagLayout());
        Constrain.add(this, new Label("Display:"), Constrain.labelLike(0, 0));
        this.nodeChoice = new Choice();
        Constrain.add(this, this.nodeChoice, Constrain.fieldLike(1, 0));
        this.nodeChoice.addItem("icons");
        this.nodeChoice.addItem("titles");
        this.nodeChoice.addItem("absolute URLs");
        this.nodeChoice.addItem("relative URLs");
        this.nodeChoice.select(g != null ? g.defaultRendering : o.defaultRendering + 1);
        Constrain.add(this, new Label("Pages:"), Constrain.labelLike(0, 1));
        this.pageChoice = new Choice();
        Constrain.add(this, this.pageChoice, Constrain.fieldLike(1, 1));
        this.pageChoice.addItem("visited pages");
        this.pageChoice.addItem("all pages");
        Constrain.add(this, new Label("Links:"), Constrain.labelLike(0, 2));
        this.linkChoice = new Choice();
        Constrain.add(this, this.linkChoice, Constrain.fieldLike(1, 2));
        this.linkChoice.addItem("tree links");
        this.linkChoice.addItem("all links");
        if (g != null) {
            switch (g.defaultFilter) {
                case 0: 
                case 1: {
                    this.pageChoice.select(0);
                    this.linkChoice.select(0);
                    break;
                }
                case 2: 
                case 3: {
                    this.pageChoice.select(1);
                    this.linkChoice.select(0);
                    break;
                }
                case 4: {
                    this.pageChoice.select(1);
                    this.linkChoice.select(1);
                }
            }
        } else {
            this.pageChoice.select(o.defaultFilter == 4 ? 1 : 0);
            this.linkChoice.disable();
        }
        this.automatic = new Checkbox("Automatic layout");
        Constrain.add(this, this.automatic, Constrain.labelLike(1, 3));
        if (g != null) {
            this.automatic.setState(g.getAutomaticLayout());
        } else {
            g.disable();
        }
        Panel panel = new Panel();
        Constrain.add(this, panel, Constrain.centered(Constrain.labelLike(0, 4, 2)));
        this.applyButton = new Button("Apply");
        panel.add(this.applyButton);
        this.okButton = new Button("OK");
        panel.add(this.okButton);
        this.cancelButton = new Button("Cancel");
        panel.add(this.cancelButton);
        this.pack();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeBack() {
        block23: {
            if (this.g != null) {
                this.g.setAutomaticLayout(this.automatic.getState());
            }
            switch (this.nodeChoice.getSelectedIndex()) {
                case 0: {
                    if (this.g != null) {
                        this.g.setNodeRendering(0);
                    }
                    if (this.o == null) break;
                    this.o.setNodeRendering(0);
                    break;
                }
                case 1: {
                    if (this.g != null) {
                        this.g.setNodeRendering(1);
                    }
                    if (this.o == null) break;
                    this.o.setNodeRendering(0);
                    break;
                }
                case 2: {
                    if (this.g != null) {
                        this.g.setNodeRendering(2);
                    }
                    if (this.o == null) break;
                    this.o.setNodeRendering(1);
                    break;
                }
                case 3: {
                    if (this.g != null) {
                        this.g.setNodeRendering(3);
                    }
                    if (this.o == null) break;
                    this.o.setNodeRendering(2);
                }
            }
            switch (this.pageChoice.getSelectedIndex()) {
                case 0: {
                    if (this.g != null) {
                        this.g.setLinkFilter(1);
                    }
                    if (this.o == null) return;
                    this.o.setLinkFilter(1);
                    return;
                }
                case 1: {
                    if (this.o != null) {
                        this.o.setLinkFilter(2);
                    }
                    switch (this.linkChoice.getSelectedIndex()) {
                        case 0: {
                            if (this.g == null) return;
                            this.g.setLinkFilter(2);
                            break block23;
                        }
                        case 1: {
                            if (this.g == null) return;
                            this.g.setLinkFilter(4);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.applyButton) {
                this.writeBack();
                return true;
            } else if (event.target == this.okButton) {
                this.writeBack();
                this.close();
                return true;
            } else {
                if (event.target != this.cancelButton) return super.handleEvent(event);
                this.close();
            }
            return true;
        } else {
            if (event.id != 201) return super.handleEvent(event);
            this.dispose();
        }
        return true;
    }
}

