/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import websphinx.Crawler;
import websphinx.Link;
import websphinx.LinkPredicate;
import websphinx.Page;
import websphinx.PagePredicate;
import websphinx.Pattern;

public class URLPredicate
implements LinkPredicate,
PagePredicate {
    Pattern pattern;

    public URLPredicate(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URLPredicate)) {
            return false;
        }
        URLPredicate p = (URLPredicate)object;
        return p.pattern.equals(this.pattern);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void connected(Crawler crawler) {
    }

    public void disconnected(Crawler crawler) {
    }

    public boolean shouldVisit(Link link) {
        return this.pattern.found(link.getURL().toString());
    }

    public boolean shouldActOn(Page page) {
        try {
            return this.pattern.found(page.getOrigin().getURL().toString());
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

