/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Choice;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.net.MalformedURLException;
import rcm.awt.Constrain;
import rcm.awt.PopupDialog;
import websphinx.Crawler;

public class CrawlerEditor
extends Panel {
    Crawler crawler;
    Label domainLabel;
    Choice domainChoice;
    Label typeLabel;
    Choice typeChoice;
    Label urlLabel;
    TextComponent urlField;
    Label depthLabel;
    Label depthLabel2;
    TextComponent depthField;
    Choice searchOrderChoice;
    String lastURL = null;
    String lastDepth = null;

    public CrawlerEditor() {
        this.setLayout(new GridBagLayout());
        this.domainLabel = new Label("Crawl:");
        Constrain.add(this, this.domainLabel, Constrain.labelLike(0, 0));
        this.domainChoice = new Choice();
        Constrain.add(this, this.domainChoice, Constrain.labelLike(1, 0, 2));
        this.domainChoice.addItem("the subtree");
        this.domainChoice.addItem("the server");
        this.domainChoice.addItem("the Web");
        this.typeLabel = new Label("Using:");
        Constrain.add(this, this.typeLabel, Constrain.labelLike(3, 0));
        this.typeChoice = new Choice();
        Constrain.add(this, this.typeChoice, Constrain.fieldLike(4, 0));
        this.typeChoice.addItem("hyperlinks");
        this.typeChoice.addItem("images+hyperlinks");
        this.typeChoice.addItem("all links");
        this.urlLabel = new Label("Starting URLs:");
        Constrain.add(this, this.urlLabel, Constrain.labelLike(0, 1));
        this.urlField = new TextArea(3, 40);
        Constrain.add(this, this.urlField, Constrain.areaLike(1, 1, 4));
        this.depthLabel = new Label("Depth:");
        Constrain.add(this, this.depthLabel, Constrain.labelLike(0, 2));
        this.depthField = new TextField(4);
        Constrain.add(this, this.depthField, Constrain.fieldLike(1, 2));
        this.depthLabel2 = new Label("  hops");
        Constrain.add(this, this.depthLabel2, Constrain.labelLike(2, 2));
        this.searchOrderChoice = new Choice();
        Constrain.add(this, this.searchOrderChoice, Constrain.fieldLike(4, 2));
        this.searchOrderChoice.addItem("Depth first");
        this.searchOrderChoice.addItem("Breadth first");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.domainChoice) {
                this.configureDomain();
                return true;
            } else if (event.target == this.urlField) {
                this.configureURL();
                return true;
            } else if (event.target == this.depthField) {
                this.configureDepth();
                return true;
            } else {
                if (event.target != this.searchOrderChoice) return super.handleEvent(event);
                this.configureDepthFirst();
            }
            return true;
        } else {
            if (event.id != 1005) return super.handleEvent(event);
            if (event.target == this.urlField) {
                this.configureURL();
                return true;
            } else {
                if (event.target != this.depthField) return super.handleEvent(event);
                this.configureDepth();
            }
        }
        return true;
    }

    public void setCrawler(Crawler crawler) {
        this.crawler = crawler;
        String[] domain = crawler.getDomain();
        if (domain == Crawler.SERVER) {
            this.domainChoice.select(1);
        } else if (domain == Crawler.SUBTREE) {
            this.domainChoice.select(0);
        } else {
            this.domainChoice.select(2);
        }
        String[] type = crawler.getLinkType();
        if (type == Crawler.HYPERLINKS_AND_IMAGES) {
            this.typeChoice.select(1);
        } else if (type == Crawler.ALL_LINKS) {
            this.typeChoice.select(2);
        } else {
            this.typeChoice.select(0);
        }
        this.urlField.setText(crawler.getRootHrefs());
        this.depthField.setText(String.valueOf(crawler.getMaxDepth()));
        this.searchOrderChoice.select(crawler.getDepthFirst() ? 0 : 1);
    }

    public Crawler getCrawler() {
        if (this.configureDomain() && this.configureType() && this.configureURL() && this.configureDepth() && this.configureDepthFirst()) {
            return this.crawler;
        }
        return null;
    }

    boolean configureDomain() {
        switch (this.domainChoice.getSelectedIndex()) {
            case 2: {
                this.crawler.setDomain(Crawler.WEB);
                break;
            }
            case 1: {
                this.crawler.setDomain(Crawler.SERVER);
                break;
            }
            case 0: {
                this.crawler.setDomain(Crawler.SUBTREE);
                break;
            }
            default: {
                throw new RuntimeException("unknown state " + this.domainChoice.getSelectedIndex());
            }
        }
        return true;
    }

    boolean configureType() {
        switch (this.typeChoice.getSelectedIndex()) {
            case 0: {
                this.crawler.setLinkType(Crawler.HYPERLINKS);
                break;
            }
            case 1: {
                this.crawler.setLinkType(Crawler.HYPERLINKS_AND_IMAGES);
                break;
            }
            case 2: {
                this.crawler.setLinkType(Crawler.ALL_LINKS);
                break;
            }
            default: {
                throw new RuntimeException("unknown state " + this.typeChoice.getSelectedIndex());
            }
        }
        return true;
    }

    boolean configureURL() {
        String hrefs = this.urlField.getText();
        try {
            this.crawler.setRootHrefs(hrefs);
            this.lastURL = hrefs;
            return true;
        }
        catch (MalformedURLException ex) {
            if (this.lastURL == null || !this.lastURL.equals(hrefs)) {
                PopupDialog.warn(this, "Error", "Improperly formed URL:\n" + hrefs);
                this.urlField.selectAll();
                this.urlField.requestFocus();
            }
            this.lastURL = hrefs;
            return false;
        }
    }

    boolean configureDepth() {
        String depth = this.depthField.getText();
        try {
            this.crawler.setMaxDepth(Integer.parseInt(depth));
            this.lastDepth = depth;
            return true;
        }
        catch (NumberFormatException ex) {
            if (this.lastDepth == null || !this.lastDepth.equals(depth)) {
                PopupDialog.warn(this, "Error", "Depth must be an integer");
                this.depthField.selectAll();
                this.depthField.requestFocus();
            }
            this.lastDepth = depth;
            return false;
        }
    }

    boolean configureDepthFirst() {
        this.crawler.setDepthFirst(this.searchOrderChoice.getSelectedIndex() == 0);
        return true;
    }
}

