/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.util.Enumeration;
import rcm.util.Str;
import websphinx.HTMLParser;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tag;
import websphinx.TagexpMatcher;
import websphinx.Wildcard;

public class Tagexp
extends Regexp {
    String stringRep;
    static HTMLParser parser = new HTMLParser();

    public Tagexp(String pattern) {
        super(Tagexp.toRegexp(pattern));
        this.stringRep = pattern;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tagexp)) {
            return false;
        }
        Tagexp p = (Tagexp)object;
        return p.stringRep.equals(this.stringRep);
    }

    public String toString() {
        return this.stringRep;
    }

    public PatternMatcher match(Region region) {
        return new TagexpMatcher(this, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toRegexp(String tagexp) {
        Page page;
        StringBuffer output = new StringBuffer();
        HTMLParser hTMLParser = parser;
        synchronized (hTMLParser) {
            page = new Page(null, tagexp, parser);
        }
        Region[] tokens = page.getTokens();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] instanceof Tag) {
                Tagexp.canonicalizeTagPattern(output, (Tag)tokens[i]);
            } else {
                Tagexp.translateText(output, tokens[i].toString());
            }
            ++i;
        }
        return output.toString();
    }

    static void canonicalizeTag(StringBuffer output, Tag tag, int j) {
        String tagName = tag.getTagName();
        if (tagName == Tag.COMMENT) {
            return;
        }
        output.append('<');
        if (tag.isEndTag()) {
            output.append('/');
        }
        output.append(tagName);
        output.append('#');
        output.append(String.valueOf(j));
        output.append('#');
        if (tag.countHTMLAttributes() > 0) {
            String[] attrs = tag.getHTMLAttributes();
            Tagexp.sortAttrs(attrs);
            int i = 0;
            while (i < attrs.length) {
                String name = attrs[i++];
                String value = attrs[i++];
                output.append(' ');
                output.append(name);
                if (value != Region.TRUE) {
                    output.append('=');
                    value = Tagexp.encodeAttrValue(value);
                    output.append(value);
                }
                output.append(' ');
            }
        }
        output.append('>');
    }

    static void canonicalizeTagPattern(StringBuffer output, Tag tag) {
        String tagName = tag.getTagName();
        if (tagName == Tag.COMMENT) {
            return;
        }
        output.append('<');
        if (tag.isEndTag()) {
            output.append('/');
        }
        Tagexp.translatePattern(output, tagName, "#");
        output.append('#');
        output.append("\\d+");
        output.append('#');
        output.append("[^>]*");
        if (tag.countHTMLAttributes() > 0) {
            String[] attrs = tag.getHTMLAttributes();
            Tagexp.sortAttrs(attrs);
            int i = 0;
            while (i < attrs.length) {
                String name = attrs[i++];
                String value = attrs[i++];
                output.append(' ');
                Tagexp.translatePattern(output, name, "= >");
                if (value != Region.TRUE) {
                    output.append('=');
                    value = Tagexp.encodeAttrValue(value);
                    Tagexp.translatePattern(output, value, " >");
                }
                output.append(' ');
                output.append("[^>]*");
            }
        }
        output.append('>');
    }

    static void sortAttrs(String[] attrs) {
        int i = 2;
        while (i < attrs.length) {
            String name = attrs[i];
            String value = attrs[i + 1];
            int j = i;
            while (j > 0 && attrs[j - 2].compareTo(name) > 0) {
                attrs[j] = attrs[j - 2];
                attrs[j + 1] = attrs[j - 1];
                j -= 2;
            }
            attrs[j] = name;
            attrs[j + 1] = value;
            i += 2;
        }
    }

    static String encodeAttrValue(String value) {
        if (value.indexOf(37) != -1) {
            value = Str.replace(value, "%", "%25");
        }
        if (value.indexOf(32) != -1) {
            value = Str.replace(value, " ", "%20");
        }
        if (value.indexOf(60) != -1) {
            value = Str.replace(value, "<", "%3C");
        }
        if (value.indexOf(62) != -1) {
            value = Str.replace(value, ">", "%3E");
        }
        return value;
    }

    static String translatePattern(StringBuffer output, String s, String delimiters) {
        s = Wildcard.toRegexp(s);
        boolean inEscape = false;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (inEscape) {
                output.append(c);
                inEscape = false;
            } else if (c == '\\') {
                output.append(c);
                inEscape = true;
            } else if (c == '.') {
                output.append("[^");
                output.append(delimiters);
                output.append(']');
            } else {
                output.append(c);
            }
            ++i;
        }
        return output.toString();
    }

    static void translateText(StringBuffer output, String s) {
        s = Str.replace(s, ".", "(?:<[^>]*>)");
        output.append(s);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: Tagexp <pattern> <source URL>*");
            return;
        }
        Tagexp p = new Tagexp(args[0].replace('_', ' '));
        int i = 1;
        while (i < args.length) {
            Page page = new Page(new Link(args[i]));
            System.out.println("-----------" + args[i]);
            PatternMatcher m = ((Pattern)p).match(page);
            Region r = m.nextMatch();
            while (r != null) {
                System.out.println("[" + r.getStart() + "," + r.getEnd() + "]" + r);
                Enumeration enumeration = r.enumerateObjectLabels();
                while (enumeration.hasMoreElements()) {
                    String lbl = (String)enumeration.nextElement();
                    Object object = r.getObjectLabel(lbl);
                    if (!(object instanceof Region)) continue;
                    Region s = (Region)object;
                    System.out.println("    " + lbl + "=[" + s.getStart() + "," + s.getEnd() + "]" + s);
                }
                r = m.nextMatch();
            }
            ++i;
        }
    }
}

