/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.util.Enumeration;
import rcm.enum.ArrayEnumeration;
import websphinx.Element;
import websphinx.HTMLParser;
import websphinx.Page;
import websphinx.Region;

public class Tag
extends Region {
    String tagName;
    boolean startTag;
    String[] htmlAttributes;
    Element element;
    public static final String A = "a".intern();
    public static final String ABBREV = "abbrev".intern();
    public static final String ACRONYM = "acronym".intern();
    public static final String ADDRESS = "address".intern();
    public static final String APPLET = "applet".intern();
    public static final String AREA = "area".intern();
    public static final String B = "b".intern();
    public static final String BASE = "base".intern();
    public static final String BASEFONT = "basefont".intern();
    public static final String BDO = "bdo".intern();
    public static final String BGSOUND = "bgsound".intern();
    public static final String BIG = "big".intern();
    public static final String BLINK = "blink".intern();
    public static final String BLOCKQUOTE = "blockquote".intern();
    public static final String BODY = "body".intern();
    public static final String BR = "br".intern();
    public static final String CAPTION = "caption".intern();
    public static final String CENTER = "center".intern();
    public static final String CITE = "cite".intern();
    public static final String CODE = "code".intern();
    public static final String COL = "col".intern();
    public static final String COLGROUP = "colgroup".intern();
    public static final String COMMENT = "!".intern();
    public static final String DD = "dd".intern();
    public static final String DEL = "del".intern();
    public static final String DFN = "dfn".intern();
    public static final String DIR = "dir".intern();
    public static final String DIV = "div".intern();
    public static final String DL = "dd".intern();
    public static final String DT = "dt".intern();
    public static final String EM = "em".intern();
    public static final String EMBED = "embed".intern();
    public static final String FONT = "font".intern();
    public static final String FRAME = "frame".intern();
    public static final String FRAMESET = "frameset".intern();
    public static final String FORM = "form".intern();
    public static final String H1 = "h1".intern();
    public static final String H2 = "h2".intern();
    public static final String H3 = "h3".intern();
    public static final String H4 = "h4".intern();
    public static final String H5 = "h5".intern();
    public static final String H6 = "h6".intern();
    public static final String HEAD = "head".intern();
    public static final String HR = "hr".intern();
    public static final String HTML = "html".intern();
    public static final String I = "i".intern();
    public static final String IMG = "img".intern();
    public static final String INPUT = "input".intern();
    public static final String ISINDEX = "isindex".intern();
    public static final String KBD = "kbd".intern();
    public static final String LI = "li".intern();
    public static final String LINK = "link".intern();
    public static final String LISTING = "listing".intern();
    public static final String MAP = "map".intern();
    public static final String MARQUEE = "marquee".intern();
    public static final String MENU = "menu".intern();
    public static final String META = "meta".intern();
    public static final String NEXTID = "nextid".intern();
    public static final String NOBR = "nobr".intern();
    public static final String NOEMBED = "noembed".intern();
    public static final String NOFRAMES = "noframes".intern();
    public static final String OBJECT = "object".intern();
    public static final String OL = "ol".intern();
    public static final String OPTION = "option".intern();
    public static final String P = "p".intern();
    public static final String PARAM = "param".intern();
    public static final String PLAINTEXT = "plaintext".intern();
    public static final String PRE = "pre".intern();
    public static final String SAMP = "samp".intern();
    public static final String SCRIPT = "script".intern();
    public static final String SELECT = "select".intern();
    public static final String SMALL = "small".intern();
    public static final String SPACER = "spacer".intern();
    public static final String STRIKE = "strike".intern();
    public static final String STRONG = "strong".intern();
    public static final String STYLE = "style".intern();
    public static final String SUB = "sub".intern();
    public static final String SUP = "sup".intern();
    public static final String TABLE = "table".intern();
    public static final String TD = "td".intern();
    public static final String TEXTAREA = "textarea".intern();
    public static final String TH = "th".intern();
    public static final String TITLE = "title".intern();
    public static final String TR = "tr".intern();
    public static final String TT = "tt".intern();
    public static final String U = "u".intern();
    public static final String UL = "ul".intern();
    public static final String VAR = "var".intern();
    public static final String WBR = "wbr".intern();
    public static final String XMP = "xmp".intern();
    public static int MAX_LENGTH = 10;

    public Tag(Page page, int start, int end, String tagName, boolean startTag) {
        super(page, start, end);
        this.tagName = tagName.toLowerCase().intern();
        this.startTag = startTag;
        this.htmlAttributes = null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Element getElement() {
        return this.element;
    }

    public static String toTagName(String name) {
        return name.toLowerCase().intern();
    }

    public boolean isStartTag() {
        return this.startTag;
    }

    public boolean isEndTag() {
        return !this.startTag;
    }

    public boolean isBlockTag() {
        return HTMLParser.blocktag.containsKey(this.tagName);
    }

    public boolean isFlowTag() {
        return !this.isBlockTag();
    }

    public boolean isHeadTag() {
        return HTMLParser.headtag.containsKey(this.tagName);
    }

    public boolean isBodyTag() {
        return !this.isHeadTag() && this.tagName != HTML && this.tagName != HEAD && this.tagName != BODY;
    }

    public static String toHTMLAttributeName(String name) {
        return name.toLowerCase().intern();
    }

    public boolean hasHTMLAttribute(String name) {
        if (this.htmlAttributes == null) {
            return false;
        }
        name = Tag.toHTMLAttributeName(name);
        int i = 0;
        while (i < this.htmlAttributes.length) {
            if (this.htmlAttributes[i] == name) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getHTMLAttribute(String name) {
        if (this.htmlAttributes == null) {
            return null;
        }
        name = Tag.toHTMLAttributeName(name);
        int i = 0;
        while (i < this.htmlAttributes.length) {
            if (this.htmlAttributes[i] == name) {
                return this.getLabel(name);
            }
            ++i;
        }
        return null;
    }

    public String getHTMLAttribute(String name, String defaultValue) {
        String val = this.getHTMLAttribute(name);
        return val != null ? val : defaultValue;
    }

    public int countHTMLAttributes() {
        return this.htmlAttributes != null ? this.htmlAttributes.length : 0;
    }

    public String[] getHTMLAttributes() {
        if (this.htmlAttributes == null) {
            return new String[0];
        }
        String[] result = new String[this.htmlAttributes.length * 2];
        int i = 0;
        int j = 0;
        while (i < this.htmlAttributes.length) {
            String name = this.htmlAttributes[i];
            result[j++] = name;
            result[j++] = this.getLabel(name);
            ++i;
        }
        return result;
    }

    public Enumeration enumerateHTMLAttributes() {
        return new ArrayEnumeration(this.htmlAttributes);
    }

    public Tag removeHTMLAttribute(String name) {
        return this.replaceHTMLAttribute(name, null);
    }

    public Tag replaceHTMLAttribute(String name) {
        return this.replaceHTMLAttribute(name, Region.TRUE);
    }

    public Tag replaceHTMLAttribute(String name, String value) {
        name = Tag.toHTMLAttributeName(name);
        if (!this.startTag) {
            return this;
        }
        StringBuffer newstr = new StringBuffer();
        String[] newattrs = null;
        newstr.append('<');
        newstr.append(this.tagName);
        boolean foundit = false;
        int len = this.htmlAttributes.length;
        int i = 0;
        while (i < len) {
            block10: {
                String attrVal;
                String attrName;
                block11: {
                    block9: {
                        attrName = this.htmlAttributes[i];
                        if (attrName != name) break block9;
                        newattrs = this.htmlAttributes;
                        foundit = true;
                        if (value == null) break block10;
                        attrVal = value;
                        break block11;
                    }
                    attrVal = this.getLabel(attrName);
                }
                newstr.append(' ');
                newstr.append(attrName);
                if (attrVal != Region.TRUE) {
                    newstr.append('=');
                    if (attrVal.indexOf(34) == -1) {
                        newstr.append('\"');
                        newstr.append(attrVal);
                        newstr.append('\"');
                    } else {
                        newstr.append('\'');
                        newstr.append(attrVal);
                        newstr.append('\'');
                    }
                }
            }
            ++i;
        }
        if (!foundit && value != null) {
            newstr.append(' ');
            newstr.append(name);
            if (value != name) {
                newstr.append('=');
                if (value.indexOf(34) == -1) {
                    newstr.append('\"');
                    newstr.append(value);
                    newstr.append('\"');
                } else {
                    newstr.append('\'');
                    newstr.append(value);
                    newstr.append('\'');
                }
            }
            newattrs = new String[len + 1];
            System.arraycopy(this.htmlAttributes, 0, newattrs, 0, len);
            newattrs[len] = name;
        }
        newstr.append('>');
        Tag newTag = new Tag(new Page(newstr.toString()), 0, newstr.length(), this.tagName, this.startTag);
        newTag.names = this.names;
        newTag.htmlAttributes = newattrs;
        newTag.setLabel(name, value);
        return newTag;
    }
}

