/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.util.Vector;
import symantec.itools.awt.InvalidTreeNodeException;
import symantec.itools.awt.TreeNode;

public class TreeView
extends Panel {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public static final int SEL_CHANGED = 1006;
    private TreeNode rootNode;
    private TreeNode selectedNode;
    private TreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar;
    int sbVPosition = 0;
    int sbVWidth;
    long sbVTimer = -1L;
    private boolean sbVShow = false;
    protected int count = 0;
    protected int viewCount = 0;
    protected Scrollbar horizontalScrollBar;
    int sbHPosition = 0;
    int sbHHeight = 0;
    private int sbHSize;
    private int newWidth = 0;
    private boolean sbHShow = false;
    private int sbHLineIncrement = 4;
    private int viewHeight = 300;
    private int viewWidth = 300;
    private int viewWidest = 0;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    private FontMetrics fm;
    protected boolean isSun1_1;
    protected Image im1;
    protected Graphics g1 = null;
    private Vector e;
    private Vector v;
    protected boolean redrawTriggered = false;
    protected boolean treeChanged = false;
    protected boolean hasFocus = false;

    public synchronized void clear() {
        this.selectedNode = null;
        this.rootNode = null;
        this.count = 0;
        this.viewCount = 0;
        this.triggerRedraw();
    }

    public void setTreeStructure(String[] s) {
        this.selectedNode = null;
        this.rootNode = null;
        try {
            this.parseTreeStructure(s);
        }
        catch (InvalidTreeNodeException e) {
            System.out.println(e);
        }
        this.triggerRedraw();
    }

    public String[] getTreeStructure() {
        if (this.rootNode == null) {
            return null;
        }
        Vector nodesVector = new Vector(this.count);
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, false, nodesVector);
        int numNodes = nodesVector.size();
        String[] treeStructure = new String[numNodes];
        int i = 0;
        while (i < numNodes) {
            TreeNode thisNode = (TreeNode)nodesVector.elementAt(i);
            String treeString = "";
            int numBlanks = 0;
            while (numBlanks < thisNode.depth) {
                treeString = treeString + " ";
                ++numBlanks;
            }
            treeStructure[i] = treeString = treeString + thisNode.text;
            ++i;
        }
        return treeStructure;
    }

    public void setFgHilite(Color c) {
    }

    public Color getFgHilite() {
        return Color.black;
    }

    public void setBgHilite(Color c) {
    }

    public Color getBgHilite() {
        return Color.white;
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] selectedObjects = new TreeNode[]{this.selectedNode};
        return selectedObjects;
    }

    public void insert(TreeNode newNode, TreeNode relativeNode, int position) {
        if (newNode == null || relativeNode == null) {
            return;
        }
        if (!this.exists(relativeNode)) {
            return;
        }
        switch (position) {
            case 0: {
                this.addChild(newNode, relativeNode);
                break;
            }
            case 1: {
                this.addSibling(newNode, relativeNode, false);
                break;
            }
            case 2: {
                this.addSibling(newNode, relativeNode, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    boolean viewable(TreeNode node) {
        int i = 0;
        while (i < this.viewCount) {
            if (node == this.v.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean viewable(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < this.viewCount) {
            TreeNode tn = (TreeNode)this.v.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean exists(TreeNode node) {
        this.recount();
        int i = 0;
        while (i < this.count) {
            if (node == this.e.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean exists(String s) {
        this.recount();
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            TreeNode tn = (TreeNode)this.e.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void append(TreeNode newNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = newNode;
            this.count = 1;
            this.triggerRedraw();
        } else {
            this.addSibling(newNode, this.rootNode, true);
        }
    }

    void addChild(TreeNode newNode, TreeNode relativeNode) {
        if (relativeNode.child == null) {
            relativeNode.child = newNode;
            newNode.parent = relativeNode;
            ++this.count;
            this.triggerRedraw();
        } else {
            this.addSibling(newNode, relativeNode.child, true);
        }
        ++relativeNode.numberOfChildren;
    }

    void addSibling(TreeNode newNode, TreeNode siblingNode) {
        this.addSibling(newNode, siblingNode, true);
    }

    void addSibling(TreeNode newNode, TreeNode siblingNode, boolean asLastSibling) {
        if (asLastSibling) {
            TreeNode tempNode = siblingNode;
            while (tempNode.sibling != null) {
                tempNode = tempNode.sibling;
            }
            tempNode.sibling = newNode;
        } else {
            newNode.sibling = siblingNode.sibling;
            siblingNode.sibling = newNode;
        }
        newNode.parent = siblingNode.parent;
        ++this.count;
        this.triggerRedraw();
    }

    public TreeNode remove(String s) {
        this.recount();
        int i = 0;
        while (i < this.count) {
            TreeNode tn = (TreeNode)this.e.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                this.remove(tn);
                this.triggerRedraw();
                return tn;
            }
            ++i;
        }
        return null;
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(TreeNode node) {
        if (!this.exists(node)) {
            return;
        }
        if (node == this.selectedNode) {
            int index = this.v.indexOf(this.selectedNode);
            if (index == -1) {
                index = this.e.indexOf(this.selectedNode);
            }
            if (index > this.viewCount - 1) {
                index = this.viewCount - 1;
            }
            if (index > 0) {
                this.changeSelection((TreeNode)this.v.elementAt(index - 1));
            } else if (this.viewCount > 1) {
                this.changeSelection((TreeNode)this.v.elementAt(1));
            }
        }
        if (node.parent != null) {
            if (node.parent.child == node) {
                if (node.sibling != null) {
                    node.parent.child = node.sibling;
                } else {
                    node.parent.child = null;
                    node.parent.collapse();
                }
            } else {
                TreeNode tn = node.parent.child;
                while (tn.sibling != node) {
                    tn = tn.sibling;
                }
                tn.sibling = node.sibling != null ? node.sibling : null;
            }
        } else if (node == this.rootNode) {
            this.rootNode = node.sibling == null ? null : node.sibling;
        } else {
            TreeNode tn = this.rootNode;
            while (tn.sibling != node) {
                tn = tn.sibling;
            }
            tn.sibling = node.sibling != null ? node.sibling : null;
        }
        this.recount();
        this.triggerRedraw();
    }

    public void printTree(TreeNode node) {
        if (node == null) {
            return;
        }
        System.out.println(node.text);
        this.printTree(node.child);
        this.printTree(node.sibling);
    }

    private void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    private void traverse(TreeNode node) {
        ++this.count;
        this.e.addElement(node);
        if (node.child != null) {
            node.child.depth = node.depth + 1;
            this.traverse(node.child);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.traverse(node.sibling);
        }
    }

    private void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, this.v);
        this.viewCount = this.v.size();
    }

    private void vectorize(TreeNode node, boolean respectExpanded, Vector nodeVector) {
        if (node == null) {
            return;
        }
        nodeVector.addElement(node);
        if (!respectExpanded && node.child != null || node.isExpanded()) {
            node.child.depth = node.depth + 1;
            this.vectorize(node.child, respectExpanded, nodeVector);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.vectorize(node.sibling, respectExpanded, nodeVector);
        }
    }

    private void debugVector() {
        int vSize = this.v.size();
        int i = 0;
        while (i < this.count) {
            TreeNode node = (TreeNode)this.v.elementAt(i);
            System.out.println(node.text);
            ++i;
        }
    }

    public synchronized boolean handleEvent(Event event) {
        if (event.target == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.scrolled();
            }
            return true;
        }
        if (event.target == this.horizontalScrollBar) {
            if (this.sbHPosition != this.horizontalScrollBar.getValue()) {
                this.sbHPosition = this.horizontalScrollBar.getValue();
                this.repaint();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int x, int y) {
        block2: {
            TreeNode newNode;
            TreeNode oldNode;
            block1: {
                this.requestFocus();
                int index = y / this.cellSize + this.sbVPosition;
                if (index > this.viewCount - 1) {
                    return true;
                }
                oldNode = this.selectedNode;
                newNode = (TreeNode)this.v.elementAt(index);
                int newDepth = newNode.getDepth();
                this.changeSelection(newNode);
                Rectangle toggleBox = new Rectangle(this.cellSize * newDepth + this.cellSize / 4 - this.sbHPosition, (index - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
                if (!toggleBox.inside(x, y)) break block1;
                newNode.toggle();
                this.triggerRedraw();
                break block2;
            }
            if (newNode != oldNode || event.clickCount != 2) break block2;
            this.sendActionEvent();
        }
        return true;
    }

    public boolean keyDown(Event event, int key) {
        int index = this.v.indexOf(this.selectedNode);
        switch (key) {
            case 13: {
                this.sendActionEvent();
                this.requestFocus();
                break;
            }
            case 1006: {
                if (event.controlDown()) {
                    if (this.sbHPosition <= 0) break;
                    this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.triggerRedraw();
                    break;
                }
            }
            case 1004: {
                if (index <= 0) break;
                this.changeSelection((TreeNode)this.v.elementAt(--index));
                this.requestFocus();
                break;
            }
            case 1007: {
                if (event.controlDown()) {
                    int max = this.horizontalScrollBar.getMaximum() - (this.isSun1_1 ? this.size().width - this.sbVWidth : 0);
                    if (!this.sbHShow || this.sbHPosition >= max) break;
                    this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, max));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 1005: {
                if (index >= this.viewCount - 1) break;
                this.changeSelection((TreeNode)this.v.elementAt(++index));
                this.requestFocus();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean gotFocus(Event e, Object what) {
        this.hasFocus = true;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true);
        }
        return true;
    }

    public boolean focusLost(Event e, Object what) {
        this.hasFocus = false;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true);
        }
        return true;
    }

    protected void sendActionEvent() {
        this.deliverEvent(new Event(this, 1001, this.selectedNode.getText()));
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    protected void changeSelection(TreeNode node) {
        if (node == this.selectedNode) {
            return;
        }
        TreeNode oldNode = this.selectedNode;
        this.selectedNode = node;
        this.drawNodeText(oldNode, (this.v.indexOf(oldNode) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(node, (this.v.indexOf(node) - this.sbVPosition) * this.cellSize, true);
        int index = this.v.indexOf(this.selectedNode);
        if (index < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (index >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.repaint();
    }

    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight) {
            this.triggerRedraw();
        }
        if (this.redrawTriggered) {
            this.redraw(g);
        }
        g.translate(-this.sbHPosition, 0);
        if (this.sbVShow && this.sbHShow) {
            g.setColor(Color.lightGray);
            g.fillRect(this.sbHPosition + d.width - this.sbVWidth, d.height - this.sbHHeight, this.sbVWidth, this.sbHHeight);
        }
        g.clipRect(this.sbHPosition, 0, d.width - this.sbVWidth, d.height - this.sbHHeight);
        g.drawImage(this.im1, 0, 0, this);
        g.setColor(Color.black);
        g.drawRect(this.sbHPosition, 0, d.width - this.sbVWidth - 1, d.height - this.sbHHeight - 1);
    }

    public void redraw() {
        this.triggerRedraw();
    }

    public void redraw(Graphics g) {
        boolean recalculate = this.treeChanged;
        int inRectCount = 0;
        this.redrawTriggered = false;
        this.treeChanged = false;
        Dimension d = this.size();
        if (recalculate) {
            this.resetVector();
            this.newWidth = this.compWidth(g);
            inRectCount = (d.height - this.sbHHeight) / this.cellSize;
            if (this.viewCount > inRectCount) {
                this.sbVShow = true;
                this.sbVWidth = this.verticalScrollBar.preferredSize().width;
            } else {
                this.sbVShow = false;
                this.sbVWidth = 0;
                this.sbVPosition = 0;
            }
            if (this.newWidth > d.width - this.sbVWidth) {
                this.sbHShow = true;
                this.sbHHeight = this.horizontalScrollBar.preferredSize().height;
            } else {
                this.sbHShow = false;
                this.sbHHeight = 0;
                this.sbHPosition = 0;
            }
        }
        this.drawTree();
        if (recalculate) {
            this.verticalScrollBar.setValues(this.sbVPosition, inRectCount, 0, this.viewCount - (this.isSun1_1 ? 0 : inRectCount));
            this.verticalScrollBar.setPageIncrement(inRectCount - 1);
            this.horizontalScrollBar.setValues(this.sbHPosition, d.width - this.sbVWidth, 0, this.sbHSize - (this.isSun1_1 ? 0 : d.width - this.sbVWidth));
            this.horizontalScrollBar.setPageIncrement(d.width - this.sbVWidth);
            this.horizontalScrollBar.setLineIncrement(this.sbHLineIncrement);
            if (this.sbVShow) {
                this.verticalScrollBar.reshape(d.width - this.sbVWidth, 0, this.sbVWidth, d.height - this.sbHHeight);
                this.verticalScrollBar.show();
            } else {
                this.verticalScrollBar.hide();
            }
            if (this.sbHShow) {
                this.horizontalScrollBar.reshape(0, d.height - this.sbHHeight, d.width - this.sbVWidth, this.sbHHeight);
                this.horizontalScrollBar.show();
            } else {
                this.horizontalScrollBar.hide();
            }
        }
    }

    private int compWidth(Graphics gg) {
        int size = 0;
        Font f = this.getFont();
        if (f == null) {
            f = new Font("TimesRoman", 0, 13);
            gg.setFont(f);
            ((Component)this).setFont(f);
        }
        this.fm = gg.getFontMetrics();
        int i = 0;
        while (i < this.v.size()) {
            TreeNode node = (TreeNode)this.v.elementAt(i);
            int textOffset = (node.depth + 1) * this.cellSize + this.cellSize + this.textInset - (node.getImage() == null ? 12 : 0);
            if (size < textOffset + this.fm.stringWidth(node.text) + 6) {
                size = textOffset + this.fm.stringWidth(node.text) + 6;
            }
            ++i;
        }
        return size;
    }

    public void drawTree() {
        Font f;
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, d.width), d.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = d.width;
            this.viewHeight = d.height;
        }
        if ((f = this.getFont()) == null) {
            f = new Font("TimesRoman", 0, 13);
            this.g1.setFont(f);
            ((Component)this).setFont(f);
        }
        if (f != null && this.g1.getFont() == null) {
            this.g1.setFont(f);
        }
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.im1.getWidth(this), d.height);
        int lastOne = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (lastOne > this.viewCount) {
            lastOne = this.viewCount;
        }
        TreeNode outerNode = null;
        if (!this.v.isEmpty()) {
            outerNode = (TreeNode)this.v.elementAt(this.sbVPosition);
        }
        int i = this.sbVPosition;
        while (i < lastOne) {
            Image nodeImage;
            TreeNode node = (TreeNode)this.v.elementAt(i);
            int x = this.cellSize * (node.depth + 1);
            int y = (i - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.getForeground());
            if (node.sibling != null) {
                int k = this.v.indexOf(node.sibling) - i;
                if (k > lastOne) {
                    k = lastOne;
                }
                this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x - this.cellSize / 2, y + this.cellSize / 2 + k * this.cellSize);
            }
            int m = 0;
            while (m < i) {
                TreeNode sib = (TreeNode)this.v.elementAt(m);
                if (sib.sibling == node && m < this.sbVPosition) {
                    this.drawDotLine(x - this.cellSize / 2, 0, x - this.cellSize / 2, y + this.cellSize / 2);
                }
                ++m;
            }
            if (node.isExpanded()) {
                this.drawDotLine(x + this.cellSize / 2, y + this.cellSize - 2, x + this.cellSize / 2, y + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.getForeground());
            this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x + this.cellSize / 2, y + this.cellSize / 2);
            if (node.isExpandable()) {
                this.g1.setColor(this.getBackground());
                this.g1.fillRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(this.getForeground());
                this.g1.drawRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 4 + 2, y + this.cellSize / 2, this.cellSize * node.depth + this.cellSize / 4 + this.clickSize - 2, y + this.cellSize / 2);
                if (!node.isExpanded()) {
                    this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + 2, this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + this.clickSize - 2);
                }
            }
            if ((nodeImage = node.getImage()) != null) {
                this.g1.drawImage(nodeImage, x + this.imageInset, y, this);
            }
            if (node.text != null) {
                this.drawNodeText(node, y, true);
            }
            if (outerNode.depth > node.depth) {
                outerNode = node;
            }
            ++i;
        }
        if (outerNode != null) {
            while ((outerNode = outerNode.parent) != null) {
                if (outerNode.sibling == null) continue;
                this.drawDotLine(this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, d.height);
            }
        }
    }

    void drawNodeText(TreeNode node, int yPosition, boolean eraseBackground) {
        Color bg;
        Color fg;
        int depth = node.depth;
        Image nodeImage = node.getImage();
        int textOffset = (depth + 1) * this.cellSize + this.cellSize + this.textInset - (nodeImage == null ? 12 : 0);
        if (node.color != null) {
            fg = this.isLight(node.color) ? Color.black : Color.white;
            Color color = node.color;
        } else {
            fg = this.getForeground();
            bg = this.getBackground();
        }
        if (eraseBackground) {
            this.g1.setColor(bg);
            this.g1.fillRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        if (node == this.selectedNode) {
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, textOffset - 1 - this.sbHPosition), yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(fg);
        this.g1.drawString(node.text, textOffset, yPosition + this.cellSize - this.textBaseLine);
    }

    private boolean isLight(Color c) {
        int min;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int n = min = r < g ? r : g;
        if (b < min) {
            min = b;
        }
        return min > 128;
    }

    private void drawDotLine(int x0, int y0, int x1, int y1) {
        if (y0 == y1) {
            int i = x0;
            while (i < x1) {
                this.g1.drawLine(i, y0, i, y1);
                i += 2;
            }
        } else {
            int i = y0;
            while (i < y1) {
                this.g1.drawLine(x0, i, x1, i);
                i += 2;
            }
        }
    }

    private void parseTreeStructure(String[] tempStructure) throws InvalidTreeNodeException {
        int i = 0;
        while (i < tempStructure.length) {
            String entry = tempStructure[i];
            int indentLevel = this.findLastPreSpace(entry);
            if (indentLevel == -1) {
                throw new InvalidTreeNodeException();
            }
            TreeNode node = new TreeNode(entry.trim());
            node.setDepth(indentLevel);
            if (this.rootNode == null) {
                if (indentLevel != 0) {
                    throw new InvalidTreeNodeException();
                }
                this.append(node);
            } else {
                int diff;
                TreeNode currentNode = this.rootNode;
                while (currentNode.sibling != null) {
                    currentNode = currentNode.sibling;
                }
                int j = 1;
                while (j < indentLevel) {
                    int numberOfChildren = currentNode.numberOfChildren;
                    TreeNode tempNode = null;
                    if (numberOfChildren > 0) {
                        tempNode = currentNode.child;
                        while (tempNode.sibling != null) {
                            tempNode = tempNode.sibling;
                        }
                    }
                    if (tempNode == null) break;
                    currentNode = tempNode;
                    ++j;
                }
                if ((diff = indentLevel - currentNode.getDepth()) > 1) {
                    throw new InvalidTreeNodeException();
                }
                if (diff == 1) {
                    this.insert(node, currentNode, 0);
                } else {
                    this.insert(node, currentNode, 1);
                }
            }
            ++i;
        }
    }

    private int findLastPreSpace(String s) {
        int length = s.length();
        if (s.charAt(0) != ' ' && s.charAt(0) != '\t') {
            return 0;
        }
        int i = 1;
        while (i < length) {
            if (s.charAt(i) != ' ' && s.charAt(i) != '\t') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public void setLayout(LayoutManager lm) {
    }

    void scrolled() {
        this.redrawTriggered = true;
        this.repaint();
    }

    protected void triggerRedraw() {
        this.redrawTriggered = true;
        this.treeChanged = true;
        this.repaint();
    }

    public TreeView() {
        super.setLayout(null);
        this.verticalScrollBar = new Scrollbar(1);
        this.verticalScrollBar.hide();
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.horizontalScrollBar.hide();
        this.add(this.horizontalScrollBar);
        this.isSun1_1 = true;
    }

    public TreeView(TreeNode head) {
        this();
        this.selectedNode = this.rootNode = head;
        this.count = 1;
    }
}

