/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import rcm.util.Timer;

class TimerManager
extends Thread {
    Timer first;
    Timer last;
    static final int FOREVER = 60000;

    public TimerManager() {
        super("Timer Manager");
        this.setDaemon(true);
        this.start();
    }

    public synchronized void register(Timer t, long deadline) {
        block6: {
            t.deadline = deadline;
            this.delete(t);
            Timer u = this.first;
            while (u != null) {
                if (t.deadline < u.deadline) {
                    if (u.prev != null) {
                        u.prev.next = t;
                    } else {
                        this.first = t;
                    }
                    t.prev = u.prev;
                    t.next = u;
                    u.prev = t;
                    break block6;
                }
                u = u.next;
            }
            if (this.last != null) {
                this.last.next = t;
                t.prev = this.last;
                t.next = null;
                this.last = t;
            } else {
                this.first = this.last = t;
            }
        }
        this.notifyAll();
    }

    public synchronized void delete(Timer t) {
        if (t.next != null) {
            t.next.prev = t.prev;
        }
        if (t.prev != null) {
            t.prev.next = t.next;
        }
        if (t == this.last) {
            this.last = t.prev;
        }
        if (t == this.first) {
            this.first = t.next;
        }
        t.next = null;
        t.prev = null;
    }

    public synchronized void run() {
        while (true) {
            try {
                if (this.first == null) {
                    this.wait(60000L);
                    continue;
                }
                Timer t = this.first;
                long now = System.currentTimeMillis();
                if (t.deadline <= now) {
                    try {
                        t.isExpired = true;
                        t.alarm();
                    }
                    catch (Throwable e) {
                        if (e instanceof ThreadDeath) {
                            throw (ThreadDeath)e;
                        }
                        e.printStackTrace();
                    }
                    if (t.periodic) {
                        this.register(t, now + (long)t.interval);
                        continue;
                    }
                    this.delete(t);
                    continue;
                }
                this.wait(t.deadline - now);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        FOREVER = 60000;
    }
}

