/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import rcm.awt.MultiLineString;

public class MultiLineLabel
extends Canvas {
    private String text;
    private MultiLineString multilabel;
    private int alignment;
    private Dimension minSize;

    public MultiLineLabel(String string) {
        this.setText(string);
        this.setAlignment(0);
    }

    public MultiLineLabel(String string, int alignment) {
        this.setText(string);
        this.setAlignment(alignment);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.multilabel = new MultiLineString(string);
        this.minSize = null;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.minSize = null;
    }

    public Dimension minimumSize() {
        if (this.minSize == null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.minSize = new Dimension(this.multilabel.getWidth(fm), this.multilabel.getHeight(fm));
        }
        return this.minSize;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public synchronized void paint(Graphics g) {
        g.setFont(this.getFont());
        this.multilabel.draw(g, 0, 0, this.alignment);
    }
}

