/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AboutPanel;
import gui.CrawlerPanel;
import gui.ExploitPanel;
import gui.FindPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import prog.Arg;
import prog.Column;
import prog.CrawlingThread;
import prog.CustomCrawler;
import prog.TestingThread;
import prog.WebPage;
import websphinx.Crawler;
import websphinx.Link;

public class MainFrame
extends JFrame {
    JTabbedPane tabs;
    CrawlerPanel cPanel;
    FindPanel fPanel;
    ExploitPanel ePanel;
    JLabel statusLabel;
    AboutPanel aPanel;
    GridBagLayout layout;
    GridBagConstraints c;
    DefaultMutableTreeNode rootNode;
    DefaultTreeModel treeModel;
    JTree tree;
    JScrollPane treeView;
    Vector<WebPage> pages;
    Vector<Arg> args;
    Vector<Column> columns;
    CrawlingThread runningCrawl;
    TestingThread runningTest;

    public MainFrame() {
        this.init();
    }

    public void init() {
        this.setTitle("Mini MySqlat0r");
        this.setDefaultCloseOperation(3);
        this.pages = new Vector();
        this.args = new Vector();
        this.columns = new Vector();
        this.layout = new GridBagLayout();
        this.getContentPane().setLayout(this.layout);
        this.c = new GridBagConstraints();
        this.tabs = new JTabbedPane();
        this.rootNode = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.cPanel = new CrawlerPanel(this, this.treeModel, this.rootNode);
        this.fPanel = new FindPanel(this);
        this.ePanel = new ExploitPanel(this);
        this.aPanel = new AboutPanel(this);
        this.tabs.addTab("Crawler", this.cPanel);
        this.tabs.addTab("SQL injection finder", this.fPanel);
        this.tabs.addTab("SQL Exploiter", this.ePanel);
        this.tabs.setAlignmentX(1.0f);
        this.tabs.addTab("About MiniMySqlat0r", this.aPanel);
        this.c.anchor = 23;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.layout.setConstraints(this.tabs, this.c);
        this.c.weighty = 0.0;
        this.c.gridy = 1;
        this.statusLabel = new JLabel("Idle");
        this.layout.setConstraints(this.statusLabel, this.c);
        this.getContentPane().add(this.tabs);
        this.getContentPane().add(this.statusLabel);
        this.pack();
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public Vector<Arg> getArgs() {
        return this.args;
    }

    public static void main(String[] args) {
        new MainFrame().setVisible(true);
    }

    public void startCrawl() {
        try {
            this.rootNode.removeAllChildren();
            this.rootNode.setUserObject(this.cPanel.urlField.getText());
            this.treeModel.reload();
            this.fPanel.tableModel.clearTable();
            this.args = new Vector();
            CustomCrawler c = new CustomCrawler(this, this.treeModel, this.rootNode, this.pages);
            c.setRoot(new Link(this.cPanel.urlField.getText()));
            c.setLinkType(Crawler.SUBTREE);
            this.runningCrawl = new CrawlingThread(this, c);
            this.runningCrawl.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopCrawl() {
        if (this.runningCrawl != null) {
            this.runningCrawl.stopit();
        }
    }

    public void testSQL() {
        this.runningTest = new TestingThread(this.args, this);
        this.runningTest.start();
    }

    public void stopSQL() {
        if (this.runningTest != null) {
            this.runningTest.stopit();
        }
    }

    public void addPage(WebPage p) {
        Vector<Arg> params = p.getParams();
        for (Arg va : params) {
            int pos = this.argPos(va);
            if (pos < 0) {
                this.args.addElement(va);
                this.fPanel.addParam(va);
                this.fPanel.table.revalidate();
                this.fPanel.repaint();
                continue;
            }
            this.args.get(pos).addValue(va.getValue());
            this.fPanel.table.revalidate();
            this.fPanel.repaint();
        }
    }

    public int argPos(Arg a) {
        int count = 0;
        for (Arg arg : this.args) {
            if (a.getPageBase().equals(arg.getPageBase()) && a.getName().equals(arg.getName()) && a.getRest().equals(arg.getRest())) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public void addColumn(Column c) {
        this.columns.addElement(c);
    }

    public CrawlerPanel getCPanel() {
        return this.cPanel;
    }

    public FindPanel getFPanel() {
        return this.fPanel;
    }

    public ExploitPanel getEPanel() {
        return this.ePanel;
    }
}

