/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpAgentCapabilities
extends SnmpType {
    private String productRelease;
    private SnmpStatus status;
    private String reference;
    private ArrayList<SnmpModuleSupport> modules;

    public SnmpAgentCapabilities(String productRelease, SnmpStatus status, String description, String reference, ArrayList<SnmpModuleSupport> modules) {
        super("AGENT-CAPABILITIES", description);
        this.productRelease = productRelease;
        this.status = status;
        this.reference = reference;
        this.modules = modules;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getFileRef(), "only values can have the " + this.getName() + " type");
        }
        for (SnmpModuleSupport module : this.modules) {
            module.initialize(log);
        }
        return this;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList<SnmpModuleSupport> getModules() {
        return this.modules;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Product Release: ");
        buffer.append(this.productRelease);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        for (SnmpModuleSupport module : this.modules) {
            buffer.append("\n  Supports Module: ");
            buffer.append(module);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

