/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import javax.swing.tree.DefaultMutableTreeNode;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibTreeNode
extends DefaultMutableTreeNode {
    private String name;
    private Object value;

    public MibTreeNode(String name, Object value) {
        super(name);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Mib getMib() {
        if (this.value instanceof Mib) {
            return (Mib)this.value;
        }
        if (this.value instanceof MibSymbol) {
            return ((MibSymbol)this.value).getMib();
        }
        if (this.value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.value).getMib();
        }
        return null;
    }

    public MibSymbol getSymbol() {
        if (this.value instanceof MibSymbol) {
            return (MibSymbol)this.value;
        }
        return null;
    }

    public MibValueSymbol getValueSymbol() {
        if (this.value instanceof MibValueSymbol) {
            return (MibValueSymbol)this.value;
        }
        return null;
    }

    public SnmpObjectType getSnmpObjectType() {
        MibValueSymbol symbol = this.getValueSymbol();
        if (symbol != null && symbol.getType() instanceof SnmpObjectType) {
            return (SnmpObjectType)symbol.getType();
        }
        return null;
    }

    public String getDescription() {
        MibSymbol symbol = this.getSymbol();
        Mib mib = this.getMib();
        if (symbol != null) {
            return symbol.getText();
        }
        if (mib != null) {
            return mib.getText();
        }
        return "";
    }

    public String getToolTipText() {
        MibSymbol symbol = this.getSymbol();
        MibType type = null;
        if (symbol instanceof MibValueSymbol) {
            type = ((MibValueSymbol)symbol).getType();
        } else if (symbol instanceof MibTypeSymbol) {
            type = ((MibTypeSymbol)symbol).getType();
        }
        if (type instanceof SnmpType) {
            String str = ((SnmpType)type).getDescription();
            if (str.indexOf(46) > 0) {
                str = str.substring(0, str.indexOf(46) + 1);
            }
            if (str.length() > 150) {
                str = str.substring(0, 150) + "...";
            }
            return str.replaceAll("[ \t\r\n]+", " ");
        }
        return null;
    }

    public MibTreeNode findChildByValue(Object value) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MibTreeNode child = (MibTreeNode)this.getChildAt(i);
            if (child.value == null || !child.value.equals(value)) continue;
            return child;
        }
        return null;
    }
}

