/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;

public class ProductionPattern {
    private int id;
    private String name;
    private boolean synthetic;
    private ArrayList alternatives;
    private int defaultAlt;
    private LookAheadSet lookAhead;

    public ProductionPattern(int id, String name) {
        this.id = id;
        this.name = name;
        this.synthetic = false;
        this.alternatives = new ArrayList();
        this.defaultAlt = -1;
        this.lookAhead = null;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isSyntetic() {
        return this.isSynthetic();
    }

    public boolean isLeftRecursive() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!alt.isLeftRecursive()) continue;
            return true;
        }
        return false;
    }

    public boolean isRightRecursive() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!alt.isRightRecursive()) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        for (int i = 0; i < this.alternatives.size(); ++i) {
            ProductionPatternAlternative alt = (ProductionPatternAlternative)this.alternatives.get(i);
            if (!alt.isMatchingEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public void setSyntetic(boolean synthetic) {
        this.setSynthetic(synthetic);
    }

    public int getAlternativeCount() {
        return this.alternatives.size();
    }

    public ProductionPatternAlternative getAlternative(int pos) {
        return (ProductionPatternAlternative)this.alternatives.get(pos);
    }

    public void addAlternative(ProductionPatternAlternative alt) throws ParserCreationException {
        if (this.alternatives.contains(alt)) {
            throw new ParserCreationException(3, this.name, "two identical alternatives exist");
        }
        alt.setPattern(this);
        this.alternatives.add(alt);
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        StringBuffer indent = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        buffer.append(this.id);
        buffer.append(") ");
        for (i = 0; i < buffer.length(); ++i) {
            indent.append(" ");
        }
        for (i = 0; i < this.alternatives.size(); ++i) {
            if (i == 0) {
                buffer.append("= ");
            } else {
                buffer.append("\n");
                buffer.append(indent);
                buffer.append("| ");
            }
            buffer.append(this.alternatives.get(i));
        }
        return buffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAhead) {
        this.lookAhead = lookAhead;
    }

    ProductionPatternAlternative getDefaultAlternative() {
        if (this.defaultAlt >= 0) {
            Object obj = this.alternatives.get(this.defaultAlt);
            return (ProductionPatternAlternative)obj;
        }
        return null;
    }

    void setDefaultAlternative(int pos) {
        if (pos >= 0 && pos < this.alternatives.size()) {
            this.defaultAlt = pos;
        }
    }
}

