/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;

public abstract class CodeElementContainer
extends CodeElement {
    private LinkedList contents = new LinkedList();

    protected void addElement(CodeElement elem) {
        if (!this.contents.contains(elem)) {
            this.contents.add(elem);
        }
    }

    protected void printContents(PrintWriter out, CodeStyle style, int indent) {
        CodeElement prev = null;
        Collections.sort(this.contents);
        for (int i = 0; i < this.contents.size(); ++i) {
            CodeElement next = (CodeElement)this.contents.get(i);
            this.printSeparator(out, style, prev, next);
            next.print(out, style, indent);
            prev = next;
        }
    }

    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
        if (prev != null && next != null && prev.category() != next.category()) {
            out.println();
        }
    }

    protected void createFile(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("couldn't create " + file + ": " + e.getMessage());
            }
        }
    }
}

