/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.net.StreamPortItem;

public class StandardSocket
implements ContextSocketFace {
    static final String version_id = "@(#)$Id: StandardSocket.java,v 1.13 2009/03/05 15:56:19 birgita Exp $ Copyright Westhawk Ltd";
    private DatagramSocket soc = null;
    private InetAddress sendToHostAddr;
    private int sendToHostPort;
    private InetAddress receiveFromHostAddr;
    private int receiveFromHostPort;
    private InetAddress locBindAddr = null;

    public void create(int port, String bindAddr) throws IOException {
        this.receiveFromHostPort = this.sendToHostPort = port;
        try {
            this.locBindAddr = null;
            if (bindAddr != null) {
                this.locBindAddr = InetAddress.getByName(bindAddr);
            }
            this.soc = new DatagramSocket(this.sendToHostPort, this.locBindAddr);
        }
        catch (SocketException exc) {
            String str = "Socket problem: port=" + port + ", bindAddr=" + bindAddr + " " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public void create(String host, int port, String bindAddr) throws IOException {
        this.receiveFromHostPort = this.sendToHostPort = port;
        try {
            this.receiveFromHostAddr = this.sendToHostAddr = InetAddress.getByName(host);
            this.locBindAddr = null;
            if (bindAddr != null) {
                this.locBindAddr = InetAddress.getByName(bindAddr);
            }
            InetSocketAddress isa = new InetSocketAddress(this.locBindAddr, 0);
            this.soc = new DatagramSocket(isa);
        }
        catch (SocketException exc) {
            String str = "Socket problem: host=" + host + ", port=" + port + ", bindAddr=" + bindAddr + " " + exc.getMessage();
            throw new IOException(str);
        }
        catch (UnknownHostException exc) {
            String str = "Cannot find host " + host + " " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public String getReceivedFromHostAddress() {
        String res = null;
        if (this.receiveFromHostAddr != null) {
            res = this.receiveFromHostAddr.getHostAddress();
        }
        return res;
    }

    public String getSendToHostAddress() {
        String res = null;
        if (this.sendToHostAddr != null) {
            res = this.sendToHostAddr.getHostAddress();
        }
        return res;
    }

    public String getLocalSocketAddress() {
        SocketAddress sa;
        String res = null;
        if (this.soc != null && (sa = this.soc.getLocalSocketAddress()) != null) {
            res = sa.toString();
        }
        return res;
    }

    public String getRemoteSocketAddress() {
        SocketAddress sa;
        String res = null;
        if (this.soc != null && (sa = this.soc.getRemoteSocketAddress()) != null) {
            res = sa.toString();
        }
        return res;
    }

    public StreamPortItem receive(int maxRecvSize) throws IOException {
        StreamPortItem item = null;
        if (this.soc != null) {
            byte[] data = new byte[maxRecvSize];
            DatagramPacket p = new DatagramPacket(data, maxRecvSize);
            this.soc.setSoTimeout(1000);
            this.soc.receive(p);
            this.receiveFromHostAddr = p.getAddress();
            this.receiveFromHostPort = p.getPort();
            ByteArrayInputStream in = null;
            in = new ByteArrayInputStream(p.getData(), 0, p.getLength());
            item = new StreamPortItem(this.receiveFromHostAddr.getHostAddress(), this.receiveFromHostPort, in);
            p = null;
        }
        return item;
    }

    public void send(byte[] packet) throws IOException {
        if (this.soc != null) {
            DatagramPacket pack = new DatagramPacket(packet, packet.length, this.sendToHostAddr, this.sendToHostPort);
            this.soc.send(pack);
        }
    }

    public void close() {
        if (this.soc != null) {
            this.soc.close();
            this.soc = null;
        }
    }
}

