/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.browser.BrowserFrame;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibbleBrowser {
    private static final String COMMAND_HELP = "A graphical SNMP MIB file browser. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleBrowser [<file(s) or URL(s)>]";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";
    private Properties buildInfo;
    private Preferences prefs;
    public MibLoader loader = new MibLoader();

    public static void main(String[] args) {
        new MibbleBrowser().start(args);
    }

    public MibbleBrowser() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
    }

    public void start(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-")) continue;
            this.printHelp("No option '" + arg + "' exist");
            System.exit(1);
        }
        this.buildInfo = new Properties();
        try {
            this.buildInfo.load(this.getClass().getResourceAsStream("build.properties"));
        }
        catch (IOException ignore) {
            this.buildInfo.setProperty("build.title", "Mibble");
        }
        try {
            String str = "com.apple.mrj.application.apple.menu.about.name";
            System.setProperty(str, this.buildInfo.getProperty("build.title"));
            str = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(str);
        }
        catch (Exception e) {
            this.printInternalError(e);
        }
        BrowserFrame frame = new BrowserFrame(this);
        frame.setVisible(true);
        ArrayList<String> list = this.getFilePrefs();
        this.removeFilePrefs();
        for (String arg : args) {
            list.add(arg);
        }
        if (list.size() > 0) {
            frame.loadMibsAsync(list.toArray(new String[list.size()]));
        } else {
            frame.loadMibsAsync(new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-MIB", "HOST-RESOURCES-MIB"});
        }
    }

    private void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            this.printError(error);
        }
    }

    private void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private void printError(String message) {
        System.err.print("Error: ");
        System.err.println(message);
    }

    public Properties getBuildInfo() {
        return this.buildInfo;
    }

    public Collection<Mib> loadMib(String src) throws IOException, MibLoaderException {
        Mib mib = null;
        File file = new File(src);
        if (this.loader.getMib(src) != null) {
            mib = this.loader.getMib(src);
            this.addFilePref(src);
        } else if (this.loader.getMib(file) != null) {
            mib = this.loader.getMib(file);
            this.addFilePref(file.getAbsolutePath());
        } else if (file.exists()) {
            if (!this.loader.hasDir(file.getParentFile())) {
                this.loader.removeAllDirs();
                this.loader.addDir(file.getParentFile());
            }
            mib = this.loader.load(file);
            this.addFilePref(file.getAbsolutePath());
        } else {
            mib = this.loader.load(src);
            this.addFilePref(src);
        }
        return this.loader.getMibs(mib.getFile()).values();
    }

    public void unloadMib(Mib mib) {
        File file = mib.getFile();
        this.removeFilePref(file.getAbsolutePath());
        if (!file.exists()) {
            this.removeFilePref(mib.getName());
        }
        try {
            this.loader.unload(mib);
        }
        catch (MibLoaderException mibLoaderException) {
            // empty catch block
        }
    }

    public void unloadAllMibs() {
        this.removeFilePrefs();
        this.loader.unloadAll();
    }

    public MibValueSymbol findMibSymbol(String oid) {
        ObjectIdentifierValue match = this.loader.getOid(oid);
        return match == null ? null : match.getSymbol();
    }

    private void addFilePref(String file) {
        ArrayList<String> list = this.getFilePrefs();
        if (!list.contains(file)) {
            this.prefs.put("file" + list.size(), file);
        }
    }

    private void removeFilePref(String file) {
        ArrayList<String> list = this.getFilePrefs();
        this.removeFilePrefs();
        list.remove(file);
        for (int i = 0; i < list.size(); ++i) {
            this.prefs.put("file" + i, list.get(i));
        }
    }

    private ArrayList<String> getFilePrefs() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            String str = this.prefs.get("file" + i, null);
            if (str == null) continue;
            list.add(str);
        }
        return list;
    }

    private void removeFilePrefs() {
        for (int i = 0; i < 1000; ++i) {
            this.prefs.remove("file" + i);
        }
    }
}

