/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibValueSymbol
extends MibSymbol {
    private MibType type;
    private MibValue value;

    public MibValueSymbol(MibFileRef fileRef, Mib mib, String name, MibType type, MibValue value) {
        super(fileRef, mib, name);
        this.type = type;
        this.value = value;
    }

    @Override
    public void initialize(MibLoaderLog log) throws MibException {
        if (this.type != null) {
            try {
                this.type = this.type.initialize(this, log);
            }
            catch (MibException e) {
                log.addError(e);
                this.type = null;
            }
        }
        if (this.value != null) {
            try {
                this.value = this.value.initialize(log, this.type);
            }
            catch (MibException e) {
                log.addError(e);
                this.value = null;
            }
        }
        if (this.type != null && this.value != null && !this.type.isCompatible(this.value)) {
            log.addError(this.getFileRef(), "value is not compatible with type");
        }
        if (this.value instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue oid = (ObjectIdentifierValue)this.value;
            if (oid.getSymbol() == null) {
                oid.setSymbol(this);
            } else {
                boolean loaded;
                boolean bl = loaded = this.getMib().isLoaded() || oid.getMib().isLoaded();
                if (oid.getSymbol() != this && loaded) {
                    log.addWarning(this.getFileRef(), "duplicate definition of " + oid + ", previously defined as '" + oid.getSymbol().getName() + "' in " + oid.getSymbol().getMib().getName());
                }
            }
        }
    }

    @Override
    void clear() {
        this.type = null;
        if (this.value != null) {
            this.value.clear();
        }
        this.value = null;
    }

    public boolean isScalar() {
        return this.type instanceof SnmpObjectType && !this.isTable() && !this.isTableRow() && !this.isTableColumn();
    }

    public boolean isTable() {
        if (this.type instanceof SnmpObjectType) {
            MibType syntax = ((SnmpObjectType)this.type).getSyntax();
            return syntax instanceof SequenceOfType;
        }
        return false;
    }

    public boolean isTableRow() {
        if (this.type instanceof SnmpObjectType) {
            MibType syntax = ((SnmpObjectType)this.type).getSyntax();
            return syntax instanceof SequenceType;
        }
        return false;
    }

    public boolean isTableColumn() {
        MibValueSymbol parent = this.getParent();
        return this.type instanceof SnmpObjectType && parent != null && parent.isTableRow();
    }

    public MibType getType() {
        return this.type;
    }

    public MibValue getValue() {
        return this.value;
    }

    public ObjectIdentifierValue getOid() {
        if (this.value instanceof ObjectIdentifierValue) {
            return (ObjectIdentifierValue)this.value;
        }
        return null;
    }

    public MibValueSymbol getParent() {
        ObjectIdentifierValue oid = this.getOid();
        ObjectIdentifierValue parent = oid != null ? oid.getParent() : null;
        return parent != null ? parent.getSymbol() : null;
    }

    public int getChildCount() {
        ObjectIdentifierValue oid = this.getOid();
        return oid != null ? oid.getChildCount() : 0;
    }

    public MibValueSymbol getChild(int index) {
        ObjectIdentifierValue oid = this.getOid();
        ObjectIdentifierValue child = oid != null ? oid.getChild(index) : null;
        return child != null ? child.getSymbol() : null;
    }

    public MibValueSymbol[] getChildren() {
        ObjectIdentifierValue oid = this.getOid();
        int count = oid != null ? oid.getChildCount() : 0;
        MibValueSymbol[] children = new MibValueSymbol[count];
        for (int i = 0; oid != null && i < count; ++i) {
            children[i] = oid.getChild(i).getSymbol();
        }
        return children;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("VALUE ");
        buffer.append(this.getName());
        buffer.append(" ");
        buffer.append(this.getType());
        buffer.append("\n    ::= ");
        buffer.append(this.getValue());
        return buffer.toString();
    }
}

