/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.stack.AsnEncoderBase;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;

class AsnEncoderv1
extends AsnEncoderBase {
    private static final String version_id = "@(#)$Id: AsnEncoderv1.java,v 3.3 2006/02/09 14:16:36 birgit Exp $ Copyright Westhawk Ltd";

    AsnEncoderv1() {
    }

    ByteArrayOutputStream EncodeSNMP(SnmpContext context, byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException, EncodingException {
        AsnSequence asnTopSeq = new AsnSequence();
        asnTopSeq.add(new AsnInteger(0));
        asnTopSeq.add(new AsnOctets(context.getCommunity()));
        AsnObject asnPduObject = this.EncodeTrap1Pdu(msg_type, enterprise, IpAddress, generic_trap, specific_trap, timeTicks, ve);
        asnTopSeq.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\n" + this.getClass().getName() + ".EncodeSNMP(): ");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    private AsnObject EncodeTrap1Pdu(byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException {
        AsnSequence asnPduObject = new AsnSequence(msg_type);
        ((AsnObject)asnPduObject).add(new AsnObjectId(enterprise));
        ((AsnObject)asnPduObject).add(new AsnOctets(IpAddress, 64));
        ((AsnObject)asnPduObject).add(new AsnInteger(generic_trap));
        ((AsnObject)asnPduObject).add(new AsnInteger(specific_trap));
        ((AsnObject)asnPduObject).add(new AsnUnsInteger(timeTicks));
        AsnObject asnVBLObject = ((AsnObject)asnPduObject).add(new AsnSequence());
        while (ve.hasMoreElements()) {
            AsnObject asnVBObject = asnVBLObject.add(new AsnSequence());
            varbind vb = (varbind)ve.nextElement();
            asnVBObject.add(vb.getOid());
            asnVBObject.add(vb.getValue());
        }
        return asnPduObject;
    }

    ByteArrayOutputStream EncodeSNMP(SnmpContext context, byte msg_type, int pduId, int errstat, int errind, Enumeration ve) throws IOException, EncodingException {
        AsnSequence asnTopSeq = new AsnSequence();
        asnTopSeq.add(new AsnInteger(0));
        asnTopSeq.add(new AsnOctets(context.getCommunity()));
        AsnObject asnPduObject = this.EncodePdu(msg_type, pduId, errstat, errind, ve);
        asnTopSeq.add(asnPduObject);
        if (AsnObject.debug > 10) {
            System.out.println("\n" + this.getClass().getName() + ".EncodeSNMP(): ");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }
}

