// ikev2_params.h
//
// this file was autogenerated at 2024-11-17T15:27:13Z
// you should edit the source file(s) instead of this one
//
// source files:
//     ikev2-parameters-1.csv
//     ikev2-parameters-2.csv
//     ikev2-parameters-3.csv
//     ikev2-parameters-4.csv
//     ikev2-parameters-5.csv
//     ikev2-parameters-6.csv
//     ikev2-parameters-7.csv
//     ikev2-parameters-8.csv
//     ikev2-parameters-9.csv
//     ikev2-parameters-10.csv
//     ikev2-parameters-11.csv
//     ikev2-parameters-12.csv
//     ikev2-parameters-14.csv
//     ikev2-parameters-16.csv
//     ikev2-parameters-17.csv
//     ikev2-parameters-18.csv
//     ikev2-parameters-19.csv
//     ikev2-parameters-20.csv
//     ikev2-parameters-21.csv
//     ikev2-parameters-22.csv
//     ikev2-parameters-23.csv
//     secure-password-methods.csv
//     hash-algorithms.csv
//     ikev2-post-quantum-preshared-key-id-types.csv
//

#ifndef IKEV2_PARAMS_H
#define IKEV2_PARAMS_H

template <typename T>
class exchange_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("exchange_type", encoded<T>::value());
        } else {
            o.print_key_string("exchange_type", name);
        }
    }
    enum code {
        IKE_SA_INIT        = 34,
        IKE_AUTH           = 35,
        CREATE_CHILD_SA    = 36,
        INFORMATIONAL      = 37,
        IKE_SESSION_RESUME = 38,
        GSA_AUTH           = 39,
        GSA_REGISTRATION   = 40,
        GSA_REKEY          = 41,
        IKE_INTERMEDIATE   = 43,
        IKE_FOLLOWUP_KE    = 44,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case IKE_SA_INIT:        return "IKE_SA_INIT";
        case IKE_AUTH:           return "IKE_AUTH";
        case CREATE_CHILD_SA:    return "CREATE_CHILD_SA";
        case INFORMATIONAL:      return "INFORMATIONAL";
        case IKE_SESSION_RESUME: return "IKE_SESSION_RESUME";
        case GSA_AUTH:           return "GSA_AUTH";
        case GSA_REGISTRATION:   return "GSA_REGISTRATION";
        case GSA_REKEY:          return "GSA_REKEY";
        case IKE_INTERMEDIATE:   return "IKE_INTERMEDIATE";
        case IKE_FOLLOWUP_KE:    return "IKE_FOLLOWUP_KE";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class payload_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("payload_type", encoded<T>::value());
        } else {
            o.print_key_string("payload_type", name);
        }
    }
    enum code {
        No_Next_Payload                      = 0,
        Security_Association                 = 33,
        Key_Exchange                         = 34,
        Identification_Initiator             = 35,
        Identification_Responder             = 36,
        Certificate                          = 37,
        Certificate_Request                  = 38,
        Authentication                       = 39,
        Nonce                                = 40,
        Notify                               = 41,
        Delete                               = 42,
        Vendor_ID                            = 43,
        Traffic_Selector_Initiator           = 44,
        Traffic_Selector_Responder           = 45,
        Encrypted_and_Authenticated          = 46,
        Configuration                        = 47,
        Extensible_Authentication            = 48,
        Generic_Secure_Password_Method       = 49,
        Group_Identification                 = 50,
        Group_Security_Association           = 51,
        Key_Download                         = 52,
        Encrypted_and_Authenticated_Fragment = 53,
        Puzzle_Solution                      = 54,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case No_Next_Payload:                      return "No_Next_Payload";
        case Security_Association:                 return "Security_Association";
        case Key_Exchange:                         return "Key_Exchange";
        case Identification_Initiator:             return "Identification_Initiator";
        case Identification_Responder:             return "Identification_Responder";
        case Certificate:                          return "Certificate";
        case Certificate_Request:                  return "Certificate_Request";
        case Authentication:                       return "Authentication";
        case Nonce:                                return "Nonce";
        case Notify:                               return "Notify";
        case Delete:                               return "Delete";
        case Vendor_ID:                            return "Vendor_ID";
        case Traffic_Selector_Initiator:           return "Traffic_Selector_Initiator";
        case Traffic_Selector_Responder:           return "Traffic_Selector_Responder";
        case Encrypted_and_Authenticated:          return "Encrypted_and_Authenticated";
        case Configuration:                        return "Configuration";
        case Extensible_Authentication:            return "Extensible_Authentication";
        case Generic_Secure_Password_Method:       return "Generic_Secure_Password_Method";
        case Group_Identification:                 return "Group_Identification";
        case Group_Security_Association:           return "Group_Security_Association";
        case Key_Download:                         return "Key_Download";
        case Encrypted_and_Authenticated_Fragment: return "Encrypted_and_Authenticated_Fragment";
        case Puzzle_Solution:                      return "Puzzle_Solution";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class transform_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("transform_type", encoded<T>::value());
        } else {
            o.print_key_string("transform_type", name);
        }
    }
    enum code {
        Encryption_Algorithm      = 1,
        Pseudo_random_Function    = 2,
        Integrity_Algorithm       = 3,
        Key_Exchange_Method       = 4,
        Extended_Sequence_Numbers = 5,
        Additional_Key_Exchange_1 = 6,
        Additional_Key_Exchange_2 = 7,
        Additional_Key_Exchange_3 = 8,
        Additional_Key_Exchange_4 = 9,
        Additional_Key_Exchange_5 = 10,
        Additional_Key_Exchange_6 = 11,
        Additional_Key_Exchange_7 = 12,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Encryption_Algorithm:      return "Encryption_Algorithm";
        case Pseudo_random_Function:    return "Pseudo_random_Function";
        case Integrity_Algorithm:       return "Integrity_Algorithm";
        case Key_Exchange_Method:       return "Key_Exchange_Method";
        case Extended_Sequence_Numbers: return "Extended_Sequence_Numbers";
        case Additional_Key_Exchange_1: return "Additional_Key_Exchange_1";
        case Additional_Key_Exchange_2: return "Additional_Key_Exchange_2";
        case Additional_Key_Exchange_3: return "Additional_Key_Exchange_3";
        case Additional_Key_Exchange_4: return "Additional_Key_Exchange_4";
        case Additional_Key_Exchange_5: return "Additional_Key_Exchange_5";
        case Additional_Key_Exchange_6: return "Additional_Key_Exchange_6";
        case Additional_Key_Exchange_7: return "Additional_Key_Exchange_7";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class transform_attribute_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("transform_attribute_type", encoded<T>::value());
        } else {
            o.print_key_string("transform_attribute_type", name);
        }
    }
    enum code {
        Key_Length = 14,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Key_Length: return "Key_Length";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class encryption_transform_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("encryption_transform_type", encoded<T>::value());
        } else {
            o.print_key_string("encryption_transform_type", name);
        }
    }
    enum code {
        ENCR_DES_IV64                 = 1,
        ENCR_DES                      = 2,
        ENCR_3DES                     = 3,
        ENCR_RC5                      = 4,
        ENCR_IDEA                     = 5,
        ENCR_CAST                     = 6,
        ENCR_BLOWFISH                 = 7,
        ENCR_3IDEA                    = 8,
        ENCR_DES_IV32                 = 9,
        ENCR_NULL                     = 11,
        ENCR_AES_CBC                  = 12,
        ENCR_AES_CTR                  = 13,
        ENCR_AES_CCM_8                = 14,
        ENCR_AES_CCM_12               = 15,
        ENCR_AES_CCM_16               = 16,
        ENCR_AES_GCM_8                = 18,
        ENCR_AES_GCM_12               = 19,
        ENCR_AES_GCM_16               = 20,
        ENCR_NULL_AUTH_AES_GMAC       = 21,
        ENCR_CAMELLIA_CBC             = 23,
        ENCR_CAMELLIA_CTR             = 24,
        ENCR_CAMELLIA_CCM_8           = 25,
        ENCR_CAMELLIA_CCM_12          = 26,
        ENCR_CAMELLIA_CCM_16          = 27,
        ENCR_CHACHA20_POLY1305        = 28,
        ENCR_AES_CCM_8_IIV            = 29,
        ENCR_AES_GCM_16_IIV           = 30,
        ENCR_CHACHA20_POLY1305_IIV    = 31,
        ENCR_KUZNYECHIK_MGM_KTREE     = 32,
        ENCR_MAGMA_MGM_KTREE          = 33,
        ENCR_KUZNYECHIK_MGM_MAC_KTREE = 34,
        ENCR_MAGMA_MGM_MAC_KTREE      = 35,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case ENCR_DES_IV64:                 return "ENCR_DES_IV64";
        case ENCR_DES:                      return "ENCR_DES";
        case ENCR_3DES:                     return "ENCR_3DES";
        case ENCR_RC5:                      return "ENCR_RC5";
        case ENCR_IDEA:                     return "ENCR_IDEA";
        case ENCR_CAST:                     return "ENCR_CAST";
        case ENCR_BLOWFISH:                 return "ENCR_BLOWFISH";
        case ENCR_3IDEA:                    return "ENCR_3IDEA";
        case ENCR_DES_IV32:                 return "ENCR_DES_IV32";
        case ENCR_NULL:                     return "ENCR_NULL";
        case ENCR_AES_CBC:                  return "ENCR_AES_CBC";
        case ENCR_AES_CTR:                  return "ENCR_AES_CTR";
        case ENCR_AES_CCM_8:                return "ENCR_AES_CCM_8";
        case ENCR_AES_CCM_12:               return "ENCR_AES_CCM_12";
        case ENCR_AES_CCM_16:               return "ENCR_AES_CCM_16";
        case ENCR_AES_GCM_8:                return "ENCR_AES_GCM_8";
        case ENCR_AES_GCM_12:               return "ENCR_AES_GCM_12";
        case ENCR_AES_GCM_16:               return "ENCR_AES_GCM_16";
        case ENCR_NULL_AUTH_AES_GMAC:       return "ENCR_NULL_AUTH_AES_GMAC";
        case ENCR_CAMELLIA_CBC:             return "ENCR_CAMELLIA_CBC";
        case ENCR_CAMELLIA_CTR:             return "ENCR_CAMELLIA_CTR";
        case ENCR_CAMELLIA_CCM_8:           return "ENCR_CAMELLIA_CCM_8";
        case ENCR_CAMELLIA_CCM_12:          return "ENCR_CAMELLIA_CCM_12";
        case ENCR_CAMELLIA_CCM_16:          return "ENCR_CAMELLIA_CCM_16";
        case ENCR_CHACHA20_POLY1305:        return "ENCR_CHACHA20_POLY1305";
        case ENCR_AES_CCM_8_IIV:            return "ENCR_AES_CCM_8_IIV";
        case ENCR_AES_GCM_16_IIV:           return "ENCR_AES_GCM_16_IIV";
        case ENCR_CHACHA20_POLY1305_IIV:    return "ENCR_CHACHA20_POLY1305_IIV";
        case ENCR_KUZNYECHIK_MGM_KTREE:     return "ENCR_KUZNYECHIK_MGM_KTREE";
        case ENCR_MAGMA_MGM_KTREE:          return "ENCR_MAGMA_MGM_KTREE";
        case ENCR_KUZNYECHIK_MGM_MAC_KTREE: return "ENCR_KUZNYECHIK_MGM_MAC_KTREE";
        case ENCR_MAGMA_MGM_MAC_KTREE:      return "ENCR_MAGMA_MGM_MAC_KTREE";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class pseudorandom_function_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("pseudorandom_function_type", encoded<T>::value());
        } else {
            o.print_key_string("pseudorandom_function_type", name);
        }
    }
    enum code {
        PRF_HMAC_MD5          = 1,
        PRF_HMAC_SHA1         = 2,
        PRF_HMAC_TIGER        = 3,
        PRF_AES128_XCBC       = 4,
        PRF_HMAC_SHA2_256     = 5,
        PRF_HMAC_SHA2_384     = 6,
        PRF_HMAC_SHA2_512     = 7,
        PRF_AES128_CMAC       = 8,
        PRF_HMAC_STREEBOG_512 = 9,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PRF_HMAC_MD5:          return "PRF_HMAC_MD5";
        case PRF_HMAC_SHA1:         return "PRF_HMAC_SHA1";
        case PRF_HMAC_TIGER:        return "PRF_HMAC_TIGER";
        case PRF_AES128_XCBC:       return "PRF_AES128_XCBC";
        case PRF_HMAC_SHA2_256:     return "PRF_HMAC_SHA2_256";
        case PRF_HMAC_SHA2_384:     return "PRF_HMAC_SHA2_384";
        case PRF_HMAC_SHA2_512:     return "PRF_HMAC_SHA2_512";
        case PRF_AES128_CMAC:       return "PRF_AES128_CMAC";
        case PRF_HMAC_STREEBOG_512: return "PRF_HMAC_STREEBOG_512";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class integrity_transform_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("integrity_transform_type", encoded<T>::value());
        } else {
            o.print_key_string("integrity_transform_type", name);
        }
    }
    enum code {
        NONE                   = 0,
        AUTH_HMAC_MD5_96       = 1,
        AUTH_HMAC_SHA1_96      = 2,
        AUTH_DES_MAC           = 3,
        AUTH_KPDK_MD5          = 4,
        AUTH_AES_XCBC_96       = 5,
        AUTH_HMAC_MD5_128      = 6,
        AUTH_HMAC_SHA1_160     = 7,
        AUTH_AES_CMAC_96       = 8,
        AUTH_AES_128_GMAC      = 9,
        AUTH_AES_192_GMAC      = 10,
        AUTH_AES_256_GMAC      = 11,
        AUTH_HMAC_SHA2_256_128 = 12,
        AUTH_HMAC_SHA2_384_192 = 13,
        AUTH_HMAC_SHA2_512_256 = 14,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case NONE:                   return "NONE";
        case AUTH_HMAC_MD5_96:       return "AUTH_HMAC_MD5_96";
        case AUTH_HMAC_SHA1_96:      return "AUTH_HMAC_SHA1_96";
        case AUTH_DES_MAC:           return "AUTH_DES_MAC";
        case AUTH_KPDK_MD5:          return "AUTH_KPDK_MD5";
        case AUTH_AES_XCBC_96:       return "AUTH_AES_XCBC_96";
        case AUTH_HMAC_MD5_128:      return "AUTH_HMAC_MD5_128";
        case AUTH_HMAC_SHA1_160:     return "AUTH_HMAC_SHA1_160";
        case AUTH_AES_CMAC_96:       return "AUTH_AES_CMAC_96";
        case AUTH_AES_128_GMAC:      return "AUTH_AES_128_GMAC";
        case AUTH_AES_192_GMAC:      return "AUTH_AES_192_GMAC";
        case AUTH_AES_256_GMAC:      return "AUTH_AES_256_GMAC";
        case AUTH_HMAC_SHA2_256_128: return "AUTH_HMAC_SHA2_256_128";
        case AUTH_HMAC_SHA2_384_192: return "AUTH_HMAC_SHA2_384_192";
        case AUTH_HMAC_SHA2_512_256: return "AUTH_HMAC_SHA2_512_256";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class diffie_hellman_group_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("diffie_hellman_group_type", encoded<T>::value());
        } else {
            o.print_key_string("diffie_hellman_group_type", name);
        }
    }
    enum code {
        NONE                                                   = 0,
        _768_bit_MODP_Group                                    = 1,
        _1024_bit_MODP_Group                                   = 2,
        _1536_bit_MODP_Group                                   = 5,
        _2048_bit_MODP_Group                                   = 14,
        _3072_bit_MODP_Group                                   = 15,
        _4096_bit_MODP_Group                                   = 16,
        _6144_bit_MODP_Group                                   = 17,
        _8192_bit_MODP_Group                                   = 18,
        _256_bit_random_ECP_group                              = 19,
        _384_bit_random_ECP_group                              = 20,
        _521_bit_random_ECP_group                              = 21,
        _1024_bit_MODP_Group_with_160_bit_Prime_Order_Subgroup = 22,
        _2048_bit_MODP_Group_with_224_bit_Prime_Order_Subgroup = 23,
        _2048_bit_MODP_Group_with_256_bit_Prime_Order_Subgroup = 24,
        _192_bit_Random_ECP_Group                              = 25,
        _224_bit_Random_ECP_Group                              = 26,
        brainpoolP224r1                                        = 27,
        brainpoolP256r1                                        = 28,
        brainpoolP384r1                                        = 29,
        brainpoolP512r1                                        = 30,
        Curve25519                                             = 31,
        Curve448                                               = 32,
        GOST3410_2012_256                                      = 33,
        GOST3410_2012_512                                      = 34,
        ml_kem_512                                             = 35,
        ml_kem_768                                             = 36,
        ml_kem_1024                                            = 37,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case NONE:                                                   return "NONE";
        case _768_bit_MODP_Group:                                    return "768_bit_MODP_Group";
        case _1024_bit_MODP_Group:                                   return "1024_bit_MODP_Group";
        case _1536_bit_MODP_Group:                                   return "1536_bit_MODP_Group";
        case _2048_bit_MODP_Group:                                   return "2048_bit_MODP_Group";
        case _3072_bit_MODP_Group:                                   return "3072_bit_MODP_Group";
        case _4096_bit_MODP_Group:                                   return "4096_bit_MODP_Group";
        case _6144_bit_MODP_Group:                                   return "6144_bit_MODP_Group";
        case _8192_bit_MODP_Group:                                   return "8192_bit_MODP_Group";
        case _256_bit_random_ECP_group:                              return "256_bit_random_ECP_group";
        case _384_bit_random_ECP_group:                              return "384_bit_random_ECP_group";
        case _521_bit_random_ECP_group:                              return "521_bit_random_ECP_group";
        case _1024_bit_MODP_Group_with_160_bit_Prime_Order_Subgroup: return "1024_bit_MODP_Group_with_160_bit_Prime_Order_Subgroup";
        case _2048_bit_MODP_Group_with_224_bit_Prime_Order_Subgroup: return "2048_bit_MODP_Group_with_224_bit_Prime_Order_Subgroup";
        case _2048_bit_MODP_Group_with_256_bit_Prime_Order_Subgroup: return "2048_bit_MODP_Group_with_256_bit_Prime_Order_Subgroup";
        case _192_bit_Random_ECP_Group:                              return "192_bit_Random_ECP_Group";
        case _224_bit_Random_ECP_Group:                              return "224_bit_Random_ECP_Group";
        case brainpoolP224r1:                                        return "brainpoolP224r1";
        case brainpoolP256r1:                                        return "brainpoolP256r1";
        case brainpoolP384r1:                                        return "brainpoolP384r1";
        case brainpoolP512r1:                                        return "brainpoolP512r1";
        case Curve25519:                                             return "Curve25519";
        case Curve448:                                               return "Curve448";
        case GOST3410_2012_256:                                      return "GOST3410_2012_256";
        case GOST3410_2012_512:                                      return "GOST3410_2012_512";
        case ml_kem_512:                                             return "ml_kem_512";
        case ml_kem_768:                                             return "ml_kem_768";
        case ml_kem_1024:                                            return "ml_kem_1024";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class extended_sequence_numbers_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("extended_sequence_numbers_type", encoded<T>::value());
        } else {
            o.print_key_string("extended_sequence_numbers_type", name);
        }
    }
    enum code {
        No_Extended_Sequence_Numbers = 0,
        Extended_Sequence_Numbers    = 1,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case No_Extended_Sequence_Numbers: return "No_Extended_Sequence_Numbers";
        case Extended_Sequence_Numbers:    return "Extended_Sequence_Numbers";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class identification_payload_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("identification_payload_type", encoded<T>::value());
        } else {
            o.print_key_string("identification_payload_type", name);
        }
    }
    enum code {
        ID_IPV4_ADDR   = 1,
        ID_FQDN        = 2,
        ID_RFC822_ADDR = 3,
        ID_IPV6_ADDR   = 5,
        ID_DER_ASN1_DN = 9,
        ID_DER_ASN1_GN = 10,
        ID_KEY_ID      = 11,
        ID_FC_NAME     = 12,
        ID_NULL        = 13,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case ID_IPV4_ADDR:   return "ID_IPV4_ADDR";
        case ID_FQDN:        return "ID_FQDN";
        case ID_RFC822_ADDR: return "ID_RFC822_ADDR";
        case ID_IPV6_ADDR:   return "ID_IPV6_ADDR";
        case ID_DER_ASN1_DN: return "ID_DER_ASN1_DN";
        case ID_DER_ASN1_GN: return "ID_DER_ASN1_GN";
        case ID_KEY_ID:      return "ID_KEY_ID";
        case ID_FC_NAME:     return "ID_FC_NAME";
        case ID_NULL:        return "ID_NULL";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class certificate_encoding_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("certificate_encoding_type", encoded<T>::value());
        } else {
            o.print_key_string("certificate_encoding_type", name);
        }
    }
    enum code {
        PKCS_7_wrapped_X_509_certificate  = 1,
        PGP_Certificate                   = 2,
        DNS_Signed_Key                    = 3,
        X_509_Certificate_Signature       = 4,
        Kerberos_Token                    = 6,
        Certificate_Revocation_List       = 7,
        Authority_Revocation_List         = 8,
        SPKI_Certificate                  = 9,
        X_509_Certificate_Attribute       = 10,
        Raw_RSA_Key                       = 11,
        Hash_and_URL_of_X_509_certificate = 12,
        Hash_and_URL_of_X_509_bundle      = 13,
        OCSP_Content                      = 14,
        Raw_Public_Key                    = 15,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PKCS_7_wrapped_X_509_certificate:  return "PKCS_7_wrapped_X_509_certificate";
        case PGP_Certificate:                   return "PGP_Certificate";
        case DNS_Signed_Key:                    return "DNS_Signed_Key";
        case X_509_Certificate_Signature:       return "X_509_Certificate_Signature";
        case Kerberos_Token:                    return "Kerberos_Token";
        case Certificate_Revocation_List:       return "Certificate_Revocation_List";
        case Authority_Revocation_List:         return "Authority_Revocation_List";
        case SPKI_Certificate:                  return "SPKI_Certificate";
        case X_509_Certificate_Attribute:       return "X_509_Certificate_Attribute";
        case Raw_RSA_Key:                       return "Raw_RSA_Key";
        case Hash_and_URL_of_X_509_certificate: return "Hash_and_URL_of_X_509_certificate";
        case Hash_and_URL_of_X_509_bundle:      return "Hash_and_URL_of_X_509_bundle";
        case OCSP_Content:                      return "OCSP_Content";
        case Raw_Public_Key:                    return "Raw_Public_Key";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class authentication_method_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("authentication_method_type", encoded<T>::value());
        } else {
            o.print_key_string("authentication_method_type", name);
        }
    }
    enum code {
        RSA_Digital_Signature                         = 1,
        Shared_Key_Message_Integrity_Code             = 2,
        DSS_Digital_Signature                         = 3,
        ECDSA_with_SHA_256_on_the_P_256_curve         = 9,
        ECDSA_with_SHA_384_on_the_P_384_curve         = 10,
        ECDSA_with_SHA_512_on_the_P_521_curve         = 11,
        Generic_Secure_Password_Authentication_Method = 12,
        NULL_Authentication                           = 13,
        Digital_Signature                             = 14,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case RSA_Digital_Signature:                         return "RSA_Digital_Signature";
        case Shared_Key_Message_Integrity_Code:             return "Shared_Key_Message_Integrity_Code";
        case DSS_Digital_Signature:                         return "DSS_Digital_Signature";
        case ECDSA_with_SHA_256_on_the_P_256_curve:         return "ECDSA_with_SHA_256_on_the_P_256_curve";
        case ECDSA_with_SHA_384_on_the_P_384_curve:         return "ECDSA_with_SHA_384_on_the_P_384_curve";
        case ECDSA_with_SHA_512_on_the_P_521_curve:         return "ECDSA_with_SHA_512_on_the_P_521_curve";
        case Generic_Secure_Password_Authentication_Method: return "Generic_Secure_Password_Authentication_Method";
        case NULL_Authentication:                           return "NULL_Authentication";
        case Digital_Signature:                             return "Digital_Signature";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class notify_message_error_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("notify_message_error_type", encoded<T>::value());
        } else {
            o.print_key_string("notify_message_error_type", name);
        }
    }
    enum code {
        UNSUPPORTED_CRITICAL_PAYLOAD = 1,
        INVALID_IKE_SPI              = 4,
        INVALID_MAJOR_VERSION        = 5,
        INVALID_SYNTAX               = 7,
        INVALID_MESSAGE_ID           = 9,
        INVALID_SPI                  = 11,
        NO_PROPOSAL_CHOSEN           = 14,
        INVALID_KE_PAYLOAD           = 17,
        AUTHENTICATION_FAILED        = 24,
        SINGLE_PAIR_REQUIRED         = 34,
        NO_ADDITIONAL_SAS            = 35,
        INTERNAL_ADDRESS_FAILURE     = 36,
        FAILED_CP_REQUIRED           = 37,
        TS_UNACCEPTABLE              = 38,
        INVALID_SELECTORS            = 39,
        UNACCEPTABLE_ADDRESSES       = 40,
        UNEXPECTED_NAT_DETECTED      = 41,
        USE_ASSIGNED_HoA             = 42,
        TEMPORARY_FAILURE            = 43,
        CHILD_SA_NOT_FOUND           = 44,
        INVALID_GROUP_ID             = 45,
        AUTHORIZATION_FAILED         = 46,
        STATE_NOT_FOUND              = 47,
        TS_MAX_QUEUE                 = 48,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case UNSUPPORTED_CRITICAL_PAYLOAD: return "UNSUPPORTED_CRITICAL_PAYLOAD";
        case INVALID_IKE_SPI:              return "INVALID_IKE_SPI";
        case INVALID_MAJOR_VERSION:        return "INVALID_MAJOR_VERSION";
        case INVALID_SYNTAX:               return "INVALID_SYNTAX";
        case INVALID_MESSAGE_ID:           return "INVALID_MESSAGE_ID";
        case INVALID_SPI:                  return "INVALID_SPI";
        case NO_PROPOSAL_CHOSEN:           return "NO_PROPOSAL_CHOSEN";
        case INVALID_KE_PAYLOAD:           return "INVALID_KE_PAYLOAD";
        case AUTHENTICATION_FAILED:        return "AUTHENTICATION_FAILED";
        case SINGLE_PAIR_REQUIRED:         return "SINGLE_PAIR_REQUIRED";
        case NO_ADDITIONAL_SAS:            return "NO_ADDITIONAL_SAS";
        case INTERNAL_ADDRESS_FAILURE:     return "INTERNAL_ADDRESS_FAILURE";
        case FAILED_CP_REQUIRED:           return "FAILED_CP_REQUIRED";
        case TS_UNACCEPTABLE:              return "TS_UNACCEPTABLE";
        case INVALID_SELECTORS:            return "INVALID_SELECTORS";
        case UNACCEPTABLE_ADDRESSES:       return "UNACCEPTABLE_ADDRESSES";
        case UNEXPECTED_NAT_DETECTED:      return "UNEXPECTED_NAT_DETECTED";
        case USE_ASSIGNED_HoA:             return "USE_ASSIGNED_HoA";
        case TEMPORARY_FAILURE:            return "TEMPORARY_FAILURE";
        case CHILD_SA_NOT_FOUND:           return "CHILD_SA_NOT_FOUND";
        case INVALID_GROUP_ID:             return "INVALID_GROUP_ID";
        case AUTHORIZATION_FAILED:         return "AUTHORIZATION_FAILED";
        case STATE_NOT_FOUND:              return "STATE_NOT_FOUND";
        case TS_MAX_QUEUE:                 return "TS_MAX_QUEUE";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class notify_message_status_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("notify_message_status_type", encoded<T>::value());
        } else {
            o.print_key_string("notify_message_status_type", name);
        }
    }
    enum code {
        INITIAL_CONTACT                     = 16384,
        SET_WINDOW_SIZE                     = 16385,
        ADDITIONAL_TS_POSSIBLE              = 16386,
        IPCOMP_SUPPORTED                    = 16387,
        NAT_DETECTION_SOURCE_IP             = 16388,
        NAT_DETECTION_DESTINATION_IP        = 16389,
        COOKIE                              = 16390,
        USE_TRANSPORT_MODE                  = 16391,
        HTTP_CERT_LOOKUP_SUPPORTED          = 16392,
        REKEY_SA                            = 16393,
        ESP_TFC_PADDING_NOT_SUPPORTED       = 16394,
        NON_FIRST_FRAGMENTS_ALSO            = 16395,
        MOBIKE_SUPPORTED                    = 16396,
        ADDITIONAL_IP4_ADDRESS              = 16397,
        ADDITIONAL_IP6_ADDRESS              = 16398,
        NO_ADDITIONAL_ADDRESSES             = 16399,
        UPDATE_SA_ADDRESSES                 = 16400,
        COOKIE2                             = 16401,
        NO_NATS_ALLOWED                     = 16402,
        AUTH_LIFETIME                       = 16403,
        MULTIPLE_AUTH_SUPPORTED             = 16404,
        ANOTHER_AUTH_FOLLOWS                = 16405,
        REDIRECT_SUPPORTED                  = 16406,
        REDIRECT                            = 16407,
        REDIRECTED_FROM                     = 16408,
        TICKET_LT_OPAQUE                    = 16409,
        TICKET_REQUEST                      = 16410,
        TICKET_ACK                          = 16411,
        TICKET_NACK                         = 16412,
        TICKET_OPAQUE                       = 16413,
        LINK_ID                             = 16414,
        USE_WESP_MODE                       = 16415,
        ROHC_SUPPORTED                      = 16416,
        EAP_ONLY_AUTHENTICATION             = 16417,
        CHILDLESS_IKEV2_SUPPORTED           = 16418,
        QUICK_CRASH_DETECTION               = 16419,
        IKEV2_MESSAGE_ID_SYNC_SUPPORTED     = 16420,
        IPSEC_REPLAY_COUNTER_SYNC_SUPPORTED = 16421,
        IKEV2_MESSAGE_ID_SYNC               = 16422,
        IPSEC_REPLAY_COUNTER_SYNC           = 16423,
        SECURE_PASSWORD_METHODS             = 16424,
        PSK_PERSIST                         = 16425,
        PSK_CONFIRM                         = 16426,
        ERX_SUPPORTED                       = 16427,
        IFOM_CAPABILITY                     = 16428,
        SENDER_REQUEST_ID                   = 16429,
        IKEV2_FRAGMENTATION_SUPPORTED       = 16430,
        SIGNATURE_HASH_ALGORITHMS           = 16431,
        CLONE_IKE_SA_SUPPORTED              = 16432,
        CLONE_IKE_SA                        = 16433,
        PUZZLE                              = 16434,
        USE_PPK                             = 16435,
        PPK_IDENTITY                        = 16436,
        NO_PPK_AUTH                         = 16437,
        INTERMEDIATE_EXCHANGE_SUPPORTED     = 16438,
        IP4_ALLOWED                         = 16439,
        IP6_ALLOWED                         = 16440,
        ADDITIONAL_KEY_EXCHANGE             = 16441,
        USE_AGGFRAG                         = 16442,
        SUPPORTED_AUTH_METHODS              = 16443,
        SA_RESOURCE_INFO                    = 16444,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case INITIAL_CONTACT:                     return "INITIAL_CONTACT";
        case SET_WINDOW_SIZE:                     return "SET_WINDOW_SIZE";
        case ADDITIONAL_TS_POSSIBLE:              return "ADDITIONAL_TS_POSSIBLE";
        case IPCOMP_SUPPORTED:                    return "IPCOMP_SUPPORTED";
        case NAT_DETECTION_SOURCE_IP:             return "NAT_DETECTION_SOURCE_IP";
        case NAT_DETECTION_DESTINATION_IP:        return "NAT_DETECTION_DESTINATION_IP";
        case COOKIE:                              return "COOKIE";
        case USE_TRANSPORT_MODE:                  return "USE_TRANSPORT_MODE";
        case HTTP_CERT_LOOKUP_SUPPORTED:          return "HTTP_CERT_LOOKUP_SUPPORTED";
        case REKEY_SA:                            return "REKEY_SA";
        case ESP_TFC_PADDING_NOT_SUPPORTED:       return "ESP_TFC_PADDING_NOT_SUPPORTED";
        case NON_FIRST_FRAGMENTS_ALSO:            return "NON_FIRST_FRAGMENTS_ALSO";
        case MOBIKE_SUPPORTED:                    return "MOBIKE_SUPPORTED";
        case ADDITIONAL_IP4_ADDRESS:              return "ADDITIONAL_IP4_ADDRESS";
        case ADDITIONAL_IP6_ADDRESS:              return "ADDITIONAL_IP6_ADDRESS";
        case NO_ADDITIONAL_ADDRESSES:             return "NO_ADDITIONAL_ADDRESSES";
        case UPDATE_SA_ADDRESSES:                 return "UPDATE_SA_ADDRESSES";
        case COOKIE2:                             return "COOKIE2";
        case NO_NATS_ALLOWED:                     return "NO_NATS_ALLOWED";
        case AUTH_LIFETIME:                       return "AUTH_LIFETIME";
        case MULTIPLE_AUTH_SUPPORTED:             return "MULTIPLE_AUTH_SUPPORTED";
        case ANOTHER_AUTH_FOLLOWS:                return "ANOTHER_AUTH_FOLLOWS";
        case REDIRECT_SUPPORTED:                  return "REDIRECT_SUPPORTED";
        case REDIRECT:                            return "REDIRECT";
        case REDIRECTED_FROM:                     return "REDIRECTED_FROM";
        case TICKET_LT_OPAQUE:                    return "TICKET_LT_OPAQUE";
        case TICKET_REQUEST:                      return "TICKET_REQUEST";
        case TICKET_ACK:                          return "TICKET_ACK";
        case TICKET_NACK:                         return "TICKET_NACK";
        case TICKET_OPAQUE:                       return "TICKET_OPAQUE";
        case LINK_ID:                             return "LINK_ID";
        case USE_WESP_MODE:                       return "USE_WESP_MODE";
        case ROHC_SUPPORTED:                      return "ROHC_SUPPORTED";
        case EAP_ONLY_AUTHENTICATION:             return "EAP_ONLY_AUTHENTICATION";
        case CHILDLESS_IKEV2_SUPPORTED:           return "CHILDLESS_IKEV2_SUPPORTED";
        case QUICK_CRASH_DETECTION:               return "QUICK_CRASH_DETECTION";
        case IKEV2_MESSAGE_ID_SYNC_SUPPORTED:     return "IKEV2_MESSAGE_ID_SYNC_SUPPORTED";
        case IPSEC_REPLAY_COUNTER_SYNC_SUPPORTED: return "IPSEC_REPLAY_COUNTER_SYNC_SUPPORTED";
        case IKEV2_MESSAGE_ID_SYNC:               return "IKEV2_MESSAGE_ID_SYNC";
        case IPSEC_REPLAY_COUNTER_SYNC:           return "IPSEC_REPLAY_COUNTER_SYNC";
        case SECURE_PASSWORD_METHODS:             return "SECURE_PASSWORD_METHODS";
        case PSK_PERSIST:                         return "PSK_PERSIST";
        case PSK_CONFIRM:                         return "PSK_CONFIRM";
        case ERX_SUPPORTED:                       return "ERX_SUPPORTED";
        case IFOM_CAPABILITY:                     return "IFOM_CAPABILITY";
        case SENDER_REQUEST_ID:                   return "SENDER_REQUEST_ID";
        case IKEV2_FRAGMENTATION_SUPPORTED:       return "IKEV2_FRAGMENTATION_SUPPORTED";
        case SIGNATURE_HASH_ALGORITHMS:           return "SIGNATURE_HASH_ALGORITHMS";
        case CLONE_IKE_SA_SUPPORTED:              return "CLONE_IKE_SA_SUPPORTED";
        case CLONE_IKE_SA:                        return "CLONE_IKE_SA";
        case PUZZLE:                              return "PUZZLE";
        case USE_PPK:                             return "USE_PPK";
        case PPK_IDENTITY:                        return "PPK_IDENTITY";
        case NO_PPK_AUTH:                         return "NO_PPK_AUTH";
        case INTERMEDIATE_EXCHANGE_SUPPORTED:     return "INTERMEDIATE_EXCHANGE_SUPPORTED";
        case IP4_ALLOWED:                         return "IP4_ALLOWED";
        case IP6_ALLOWED:                         return "IP6_ALLOWED";
        case ADDITIONAL_KEY_EXCHANGE:             return "ADDITIONAL_KEY_EXCHANGE";
        case USE_AGGFRAG:                         return "USE_AGGFRAG";
        case SUPPORTED_AUTH_METHODS:              return "SUPPORTED_AUTH_METHODS";
        case SA_RESOURCE_INFO:                    return "SA_RESOURCE_INFO";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class notification_ipcomp_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("notification_ipcomp_type", encoded<T>::value());
        } else {
            o.print_key_string("notification_ipcomp_type", name);
        }
    }
    enum code {
        IPCOMP_OUI     = 1,
        IPCOMP_DEFLATE = 2,
        IPCOMP_LZS     = 3,
        IPCOMP_LZJH    = 4,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case IPCOMP_OUI:     return "IPCOMP_OUI";
        case IPCOMP_DEFLATE: return "IPCOMP_DEFLATE";
        case IPCOMP_LZS:     return "IPCOMP_LZS";
        case IPCOMP_LZJH:    return "IPCOMP_LZJH";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class security_protocol_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("security_protocol_type", encoded<T>::value());
        } else {
            o.print_key_string("security_protocol_type", name);
        }
    }
    enum code {
        IKE                  = 1,
        AH                   = 2,
        ESP                  = 3,
        FC_ESP_HEADER        = 4,
        FC_CT_AUTHENTICATION = 5,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case IKE:                  return "IKE";
        case AH:                   return "AH";
        case ESP:                  return "ESP";
        case FC_ESP_HEADER:        return "FC_ESP_HEADER";
        case FC_CT_AUTHENTICATION: return "FC_CT_AUTHENTICATION";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class traffic_selector_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("traffic_selector_type", encoded<T>::value());
        } else {
            o.print_key_string("traffic_selector_type", name);
        }
    }
    enum code {
        TS_IPV4_ADDR_RANGE = 7,
        TS_IPV6_ADDR_RANGE = 8,
        TS_FC_ADDR_RANGE   = 9,
        TS_SECLABEL        = 10,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case TS_IPV4_ADDR_RANGE: return "TS_IPV4_ADDR_RANGE";
        case TS_IPV6_ADDR_RANGE: return "TS_IPV6_ADDR_RANGE";
        case TS_FC_ADDR_RANGE:   return "TS_FC_ADDR_RANGE";
        case TS_SECLABEL:        return "TS_SECLABEL";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class configuration_payload_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("configuration_payload_type", encoded<T>::value());
        } else {
            o.print_key_string("configuration_payload_type", name);
        }
    }
    enum code {
        CFG_REQUEST = 1,
        CFG_REPLY   = 2,
        CFG_SET     = 3,
        CFG_ACK     = 4,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case CFG_REQUEST: return "CFG_REQUEST";
        case CFG_REPLY:   return "CFG_REPLY";
        case CFG_SET:     return "CFG_SET";
        case CFG_ACK:     return "CFG_ACK";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class configuration_payload_attribute_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("configuration_payload_attribute_type", encoded<T>::value());
        } else {
            o.print_key_string("configuration_payload_attribute_type", name);
        }
    }
    enum code {
        INTERNAL_IP4_ADDRESS              = 1,
        INTERNAL_IP4_NETMASK              = 2,
        INTERNAL_IP4_DNS                  = 3,
        INTERNAL_IP4_NBNS                 = 4,
        INTERNAL_IP4_DHCP                 = 6,
        APPLICATION_VERSION               = 7,
        INTERNAL_IP6_ADDRESS              = 8,
        INTERNAL_IP6_DNS                  = 10,
        INTERNAL_IP6_DHCP                 = 12,
        INTERNAL_IP4_SUBNET               = 13,
        SUPPORTED_ATTRIBUTES              = 14,
        INTERNAL_IP6_SUBNET               = 15,
        MIP6_HOME_PREFIX                  = 16,
        INTERNAL_IP6_LINK                 = 17,
        INTERNAL_IP6_PREFIX               = 18,
        HOME_AGENT_ADDRESS                = 19,
        P_CSCF_IP4_ADDRESS                = 20,
        P_CSCF_IP6_ADDRESS                = 21,
        FTT_KAT                           = 22,
        EXTERNAL_SOURCE_IP4_NAT_INFO      = 23,
        TIMEOUT_PERIOD_FOR_LIVENESS_CHECK = 24,
        INTERNAL_DNS_DOMAIN               = 25,
        INTERNAL_DNSSEC_TA                = 26,
        ENCDNS_IP4                        = 27,
        ENCDNS_IP6                        = 28,
        ENCDNS_DIGEST_INFO                = 29,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case INTERNAL_IP4_ADDRESS:              return "INTERNAL_IP4_ADDRESS";
        case INTERNAL_IP4_NETMASK:              return "INTERNAL_IP4_NETMASK";
        case INTERNAL_IP4_DNS:                  return "INTERNAL_IP4_DNS";
        case INTERNAL_IP4_NBNS:                 return "INTERNAL_IP4_NBNS";
        case INTERNAL_IP4_DHCP:                 return "INTERNAL_IP4_DHCP";
        case APPLICATION_VERSION:               return "APPLICATION_VERSION";
        case INTERNAL_IP6_ADDRESS:              return "INTERNAL_IP6_ADDRESS";
        case INTERNAL_IP6_DNS:                  return "INTERNAL_IP6_DNS";
        case INTERNAL_IP6_DHCP:                 return "INTERNAL_IP6_DHCP";
        case INTERNAL_IP4_SUBNET:               return "INTERNAL_IP4_SUBNET";
        case SUPPORTED_ATTRIBUTES:              return "SUPPORTED_ATTRIBUTES";
        case INTERNAL_IP6_SUBNET:               return "INTERNAL_IP6_SUBNET";
        case MIP6_HOME_PREFIX:                  return "MIP6_HOME_PREFIX";
        case INTERNAL_IP6_LINK:                 return "INTERNAL_IP6_LINK";
        case INTERNAL_IP6_PREFIX:               return "INTERNAL_IP6_PREFIX";
        case HOME_AGENT_ADDRESS:                return "HOME_AGENT_ADDRESS";
        case P_CSCF_IP4_ADDRESS:                return "P_CSCF_IP4_ADDRESS";
        case P_CSCF_IP6_ADDRESS:                return "P_CSCF_IP6_ADDRESS";
        case FTT_KAT:                           return "FTT_KAT";
        case EXTERNAL_SOURCE_IP4_NAT_INFO:      return "EXTERNAL_SOURCE_IP4_NAT_INFO";
        case TIMEOUT_PERIOD_FOR_LIVENESS_CHECK: return "TIMEOUT_PERIOD_FOR_LIVENESS_CHECK";
        case INTERNAL_DNS_DOMAIN:               return "INTERNAL_DNS_DOMAIN";
        case INTERNAL_DNSSEC_TA:                return "INTERNAL_DNSSEC_TA";
        case ENCDNS_IP4:                        return "ENCDNS_IP4";
        case ENCDNS_IP6:                        return "ENCDNS_IP6";
        case ENCDNS_DIGEST_INFO:                return "ENCDNS_DIGEST_INFO";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class gateway_identity_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("gateway_identity_type", encoded<T>::value());
        } else {
            o.print_key_string("gateway_identity_type", name);
        }
    }
    enum code {
        IPv4_address_of_the_VPN_gateway = 1,
        IPv6_address_of_the_VPN_gateway = 2,
        FQDN_of_the_VPN_gateway         = 3,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case IPv4_address_of_the_VPN_gateway: return "IPv4_address_of_the_VPN_gateway";
        case IPv6_address_of_the_VPN_gateway: return "IPv6_address_of_the_VPN_gateway";
        case FQDN_of_the_VPN_gateway:         return "FQDN_of_the_VPN_gateway";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class rohc_attribute_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("rohc_attribute_type", encoded<T>::value());
        } else {
            o.print_key_string("rohc_attribute_type", name);
        }
    }
    enum code {
        Maximum_Context_Identifier           = 1,
        ROHC_Profile                         = 2,
        ROHC_Integrity_Algorithm             = 3,
        ROHC_ICV_Length_in_bytes             = 4,
        Maximum_Reconstructed_Reception_Unit = 5,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Maximum_Context_Identifier:           return "Maximum_Context_Identifier";
        case ROHC_Profile:                         return "ROHC_Profile";
        case ROHC_Integrity_Algorithm:             return "ROHC_Integrity_Algorithm";
        case ROHC_ICV_Length_in_bytes:             return "ROHC_ICV_Length_in_bytes";
        case Maximum_Reconstructed_Reception_Unit: return "Maximum_Reconstructed_Reception_Unit";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class secure_password_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("secure_password_type", encoded<T>::value());
        } else {
            o.print_key_string("secure_password_type", name);
        }
    }
    enum code {
        PACE                      = 1,
        AugPAKE                   = 2,
        Secure_PSK_Authentication = 3,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PACE:                      return "PACE";
        case AugPAKE:                   return "AugPAKE";
        case Secure_PSK_Authentication: return "Secure_PSK_Authentication";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class hash_algorithm_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("hash_algorithm_type", encoded<T>::value());
        } else {
            o.print_key_string("hash_algorithm_type", name);
        }
    }
    enum code {
        SHA1         = 1,
        SHA2_256     = 2,
        SHA2_384     = 3,
        SHA2_512     = 4,
        Identity     = 5,
        STREEBOG_256 = 6,
        STREEBOG_512 = 7,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case SHA1:         return "SHA1";
        case SHA2_256:     return "SHA2_256";
        case SHA2_384:     return "SHA2_384";
        case SHA2_512:     return "SHA2_512";
        case Identity:     return "Identity";
        case STREEBOG_256: return "STREEBOG_256";
        case STREEBOG_512: return "STREEBOG_512";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class postquantum_preshared_key_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("postquantum_preshared_key_type", encoded<T>::value());
        } else {
            o.print_key_string("postquantum_preshared_key_type", name);
        }
    }
    enum code {
        PPK_ID_OPAQUE = 1,
        PPK_ID_FIXED  = 2,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case PPK_ID_OPAQUE: return "PPK_ID_OPAQUE";
        case PPK_ID_FIXED:  return "PPK_ID_FIXED";
        default:
            ;
        }
        return nullptr;
    }
};


#endif // IKEV2_PARAMS_H
