// hpke_params.h
//
// this file was autogenerated at 2024-02-13T22:03:37Z
// you should edit the source file(s) instead of this one
//
// source files:
//     hpke-kem-ids.csv
//     hpke-aead-ids.csv
//     hpke-kdf-ids.csv
//

#ifndef HPKE_PARAMS_H
#define HPKE_PARAMS_H

#include "json_object.h"

namespace hpke {

template <typename T>
class kem : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("kem", encoded<T>::value());
        } else {
            o.print_key_string("kem", name);
        }
    }
    enum code {
        DHKEM_P256_HKDF_SHA256      = 0x0010,
        DHKEM_P384_HKDF_SHA384      = 0x0011,
        DHKEM_P521_HKDF_SHA512      = 0x0012,
        DHKEM_CP256_HKDF_SHA256     = 0x0013,
        DHKEM_CP384_HKDF_SHA384     = 0x0014,
        DHKEM_CP521_HKDF_SHA512     = 0x0015,
        DHKEM_secp256k1_HKDF_SHA256 = 0x0016,
        DHKEM_X25519_HKDF_SHA256    = 0x0020,
        DHKEM_X448_HKDF_SHA512      = 0x0021,
        X25519Kyber768Draft00       = 0x0030,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case DHKEM_P256_HKDF_SHA256:      return "DHKEM_P256_HKDF_SHA256";
        case DHKEM_P384_HKDF_SHA384:      return "DHKEM_P384_HKDF_SHA384";
        case DHKEM_P521_HKDF_SHA512:      return "DHKEM_P521_HKDF_SHA512";
        case DHKEM_CP256_HKDF_SHA256:     return "DHKEM_CP256_HKDF_SHA256";
        case DHKEM_CP384_HKDF_SHA384:     return "DHKEM_CP384_HKDF_SHA384";
        case DHKEM_CP521_HKDF_SHA512:     return "DHKEM_CP521_HKDF_SHA512";
        case DHKEM_secp256k1_HKDF_SHA256: return "DHKEM_secp256k1_HKDF_SHA256";
        case DHKEM_X25519_HKDF_SHA256:    return "DHKEM_X25519_HKDF_SHA256";
        case DHKEM_X448_HKDF_SHA512:      return "DHKEM_X448_HKDF_SHA512";
        case X25519Kyber768Draft00:       return "X25519Kyber768Draft00";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class aead : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("aead", encoded<T>::value());
        } else {
            o.print_key_string("aead", name);
        }
    }
    enum code {
        AES_128_GCM      = 0x0001,
        AES_256_GCM      = 0x0002,
        ChaCha20Poly1305 = 0x0003,
        Export_only      = 0xFFFF,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case AES_128_GCM:      return "AES_128_GCM";
        case AES_256_GCM:      return "AES_256_GCM";
        case ChaCha20Poly1305: return "ChaCha20Poly1305";
        case Export_only:      return "Export_only";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class kdf : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("kdf", encoded<T>::value());
        } else {
            o.print_key_string("kdf", name);
        }
    }
    enum code {
        HKDF_SHA256 = 0x0001,
        HKDF_SHA384 = 0x0002,
        HKDF_SHA512 = 0x0003,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case HKDF_SHA256: return "HKDF_SHA256";
        case HKDF_SHA384: return "HKDF_SHA384";
        case HKDF_SHA512: return "HKDF_SHA512";
        default:
            ;
        }
        return nullptr;
    }
};

};

#endif // HPKE_PARAMS_H
