/*
 * Decompiled with CFR 0.152.
 */
package marshalsec.gadgets;

import com.google.inject.internal.Annotations;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import marshalsec.gadgets.JDKUtil;
import marshalsec.util.Reflections;

public class MockProxies {
    public static Object makeProxy(MockProxyType t, String method, Object iter, Class<?> ... types) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        switch (t) {
            case GUICE: {
                return MockProxies.makeProxyGuice(method, iter, types);
            }
            case HIBERNATEVAL: {
                return MockProxies.makeProxyHibernate(method, iter, types);
            }
        }
        return MockProxies.makeProxyJava(method, iter, types);
    }

    private static Object makeProxyJava(String method, Object iter, Class<?> ... types) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(method, iter);
        return Proxy.newProxyInstance(MockProxies.class.getClassLoader(), types, JDKUtil.createMemoizedInvocationHandler(values));
    }

    private static Object makeProxyGuice(String method, Object iter, Class<?> ... types) throws Exception {
        Method meth = Annotations.class.getDeclaredMethod("generateAnnotationImpl", Class.class);
        meth.setAccessible(true);
        Object o = meth.invoke(null, Override.class);
        InvocationHandler inv = Proxy.getInvocationHandler(o);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(method, iter);
        Reflections.setFieldValue(inv, "val$members", values);
        return Proxy.newProxyInstance(MockProxies.class.getClassLoader(), types, inv);
    }

    private static Object makeProxyHibernate(String method, Object iter, Class<?> ... types) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        Class<?> invhcl = Class.forName("org.hibernate.validator.util.annotationfactory.AnnotationProxy");
        InvocationHandler invh = (InvocationHandler)Reflections.createWithoutConstructor(invhcl);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(method, iter);
        Reflections.setFieldValue(invh, "values", values);
        return Proxy.newProxyInstance(MockProxies.class.getClassLoader(), types, invh);
    }

    public static enum MockProxyType {
        GUICE,
        HIBERNATEVAL,
        JAVA;

    }
}

