/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.ProbeDescription;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="A marker containing code coverage information.")
@ValidOn(value={JDefinedClassOrInterface.class})
public class CodeCoverageMarker
implements Marker {
    public static final long INVALID_CLASS_ID = -1L;
    @Nonnull
    private final List<ProbeDescription> probes;
    private long classId;
    @CheckForNull
    private JMethod initMethod;

    @Nonnull
    public synchronized ProbeDescription createProbe(@Nonnull JMethod method) {
        ProbeDescription p = new ProbeDescription(this.probes.size(), method);
        this.probes.add(p);
        return p;
    }

    public CodeCoverageMarker() {
        this(-1L, new ArrayList<ProbeDescription>());
    }

    private CodeCoverageMarker(long classId, @Nonnull List<ProbeDescription> probes) {
        this.classId = classId;
        this.probes = probes;
    }

    public long getClassId() {
        return this.classId;
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    @Nonnull
    public List<ProbeDescription> getProbes() {
        return this.probes;
    }

    @Nonnegative
    public int getNumberOfProbes() {
        return this.probes.size();
    }

    @CheckForNull
    public JMethod getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(@Nonnull JMethod initMethod) {
        this.initMethod = initMethod;
    }

    public Marker cloneIfNeeded() {
        CodeCoverageMarker marker = new CodeCoverageMarker(this.classId, this.probes);
        if (this.initMethod != null) {
            marker.setInitMethod(this.initMethod);
        }
        return marker;
    }

    @Description(value="The CodeCoverageMarker is complete.")
    @Name(value="CodeCoverageMarker.Complete")
    public static final class Complete
    implements Tag {
    }

    @Description(value="The CodeCoverageMarker is analyzed.")
    @Name(value="CodeCoverageMarker.Analyzed")
    public static final class Analyzed
    implements Tag {
    }

    @Description(value="The CodeCoverageMarker is initialized.")
    @Name(value="CodeCoverageMarker.Initialized")
    public static final class Initialized
    implements Tag {
    }
}

