/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class TableSwitchInsnNode
extends AbstractInsnNode {
    public int register;
    public int min;
    public int max;
    public LabelNode dflt;
    public List<LabelNode> labels;

    public TableSwitchInsnNode(int register, int min, int max, LabelNode dflt, LabelNode[] labels) {
        super(43);
        this.register = register;
        this.min = min;
        this.max = max;
        this.dflt = dflt;
        this.labels = new ArrayList<LabelNode>();
        if (labels != null) {
            this.labels.addAll(Arrays.asList(labels));
        }
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void accept(MethodVisitor mv) {
        Label[] labels = new Label[this.labels.size()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = this.labels.get(i).getLabel();
            ++i;
        }
        mv.visitTableSwitchInsn(this.register, this.min, this.max, this.dflt.getLabel(), labels);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        return new TableSwitchInsnNode(this.register, this.min, this.max, TableSwitchInsnNode.clone(this.dflt, labels), TableSwitchInsnNode.clone(this.labels, labels));
    }
}

