/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.tree.LabelNode;

public class LocalVariableNode {
    public String name;
    public String desc;
    public String signature;
    public LabelNode start;
    public List<LabelNode> ends;
    public List<LabelNode> restarts;
    public int index;

    public LocalVariableNode(String name, String desc, String signature, LabelNode start, LabelNode end, int index) {
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.start = start;
        if (end != null) {
            this.ends = new ArrayList<LabelNode>(1);
            this.ends.add(end);
        }
        this.index = index;
    }

    public LocalVariableNode(String name, String desc, String signature, LabelNode start, List<LabelNode> ends, List<LabelNode> restarts, int index) {
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.start = start;
        this.ends = ends;
        this.restarts = restarts;
        this.index = index;
    }

    public void accept(MethodVisitor mv) {
        mv.visitLocalVariable(this.name, this.desc, this.signature, this.start == null ? null : this.start.getLabel(), this.getLabels(this.ends), this.getLabels(this.restarts), this.index);
    }

    private List<Label> getLabels(List<LabelNode> labelNodes) {
        ArrayList<Label> labels = null;
        if (labelNodes != null) {
            labels = new ArrayList<Label>(labelNodes.size());
            for (LabelNode labelNode : labelNodes) {
                labels.add(labelNode.getLabel());
            }
        }
        return labels;
    }
}

