/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.Map;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class JumpInsnNode
extends AbstractInsnNode {
    public LabelNode label;
    public int registerA;
    public int registerB;

    public JumpInsnNode(int opcode, LabelNode label, int registerA, int registerB) {
        super(opcode);
        this.label = label;
        this.registerA = registerA;
        this.registerB = registerB;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void accept(MethodVisitor mv) {
        mv.visitJumpInsn(this.opcode, this.label.getLabel(), this.registerA, this.registerB);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        return new JumpInsnNode(this.opcode, JumpInsnNode.clone(this.label, labels), this.registerA, this.registerB);
    }
}

