/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureCommon.LocalVariable;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.AnnotationSetRefList;
import org.ow2.asmdex.structureWriter.CodeItem;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.IAnnotationsHolder;
import org.ow2.asmdex.structureWriter.Prototype;

public class Method
implements Comparable<Method>,
IAnnotationsHolder {
    private final String className;
    private final Prototype prototype;
    private final String methodName;
    private int access;
    private String[] exceptionNames;
    private int startBytecodeToCopy;
    private int startDebugInfoToCopy;
    private CodeItem codeItem;
    private AnnotationSetItem annotationSetItem = new AnnotationSetItem();
    private AnnotationSetRefList annotatedParameterSetRefList;
    private String[] parameters;
    private List<LocalVariable> localVariables = new ArrayList<LocalVariable>();
    private String[] signature;
    private final int hashcode;

    public Method(String methodName, String className, Prototype methodDescriptor) {
        this.methodName = methodName;
        this.className = className;
        this.prototype = methodDescriptor;
        this.hashcode = Method.calculateHashCode(methodName, className, this.prototype);
    }

    public void init(int access, String[] signature, String[] exceptionNames, ConstantPool constantPool) {
        this.access = access;
        this.exceptionNames = exceptionNames;
        this.signature = signature;
        if (!this.isUnknown() && !this.isAbstractOrInterface()) {
            this.codeItem = new CodeItem(this, constantPool);
        }
        this.annotatedParameterSetRefList = new AnnotationSetRefList(this.prototype.getNbParameters(), this);
    }

    public void addLocalVariable(LocalVariable localVariable) {
        this.localVariables.add(localVariable);
    }

    public void completeInformation(int access, String[] exceptionNames, String[] signature, ConstantPool constantPool) {
        this.access = access;
        this.exceptionNames = exceptionNames;
        this.signature = signature;
        if (this.codeItem == null && !this.isUnknown() && !this.isAbstractOrInterface()) {
            this.codeItem = new CodeItem(this, constantPool);
        }
    }

    public static int calculateHashCode(String methodName, String className, Prototype prototype) {
        return methodName.hashCode() + className.hashCode() + prototype.hashCode();
    }

    public static int calculateHashCode(String methodName, String className, int prototypeHashCode) {
        return methodName.hashCode() + className.hashCode() + prototypeHashCode;
    }

    public boolean isVirtual() {
        return (this.access & 8) + (this.access & 2) + (this.access & 0x10000) == 0;
    }

    public boolean isDirect() {
        return !this.isVirtual();
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isAbstractOrInterface() {
        return (this.access & 0x400 | this.access & 0x200) != 0;
    }

    public boolean isUnknown() {
        return (this.access & 0x40000) != 0;
    }

    public boolean isUsingThis() {
        return !this.isStatic() && (this.access & 0x10000) == 0;
    }

    public void addAnnotationItem(AnnotationItem annotationItem) {
        this.annotationSetItem.addAnnotationItem(annotationItem);
    }

    public void addParameterAnnotationItem(int parameterIndex, AnnotationItem annotationItem) {
        this.annotatedParameterSetRefList.addAnnotationItem(parameterIndex, annotationItem);
    }

    public void closeAnnotations(ConstantPool constantPool) {
        this.annotatedParameterSetRefList.close();
        constantPool.addAnnotationSetItemToConstantPool(this.annotationSetItem);
        constantPool.addAnnotationSetRefListToConstantPool(this.annotatedParameterSetRefList);
    }

    public void generateCodeItemCode() {
        this.codeItem.generateCodeItemCode();
    }

    public void free() {
        this.codeItem.free();
    }

    public ByteVector getCodeItemCode() {
        return this.codeItem.getCodeItemCode();
    }

    public ByteVector getCodeItemTryCatch() {
        return this.codeItem.getCodeItemTryCatch();
    }

    public void setStartBytecodeToCopy(int start) {
        this.startBytecodeToCopy = start;
    }

    public int getStartBytecodeToCopy() {
        return this.startBytecodeToCopy;
    }

    public void setStartDebugInfoToCopy(int start) {
        this.startDebugInfoToCopy = start;
    }

    public int getStartDebugInfoToCopy() {
        return this.startDebugInfoToCopy;
    }

    public String getClassName() {
        return this.className;
    }

    public Prototype getPrototype() {
        return this.prototype;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getAccess() {
        return this.access;
    }

    public String[] getExceptionNames() {
        return this.exceptionNames;
    }

    public CodeItem getCodeItem() {
        return this.codeItem;
    }

    @Override
    public AnnotationSetItem getAnnotationSetItem() {
        return this.annotationSetItem;
    }

    @Override
    public int getNbAnnotations() {
        return this.annotationSetItem.getNbAnnotationItems();
    }

    public AnnotationSetRefList getAnnotatedParameterSetRefList() {
        return this.annotatedParameterSetRefList;
    }

    public int getNbParameterAnnotations() {
        return this.annotatedParameterSetRefList.getNbAnnotationSetItemsUsed();
    }

    public int getNbParameters() {
        return this.prototype.getNbParameters();
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public void setFirstLineNumberIfNeeded(int firstLineNumber) {
        this.codeItem.setFirstLineNumber(firstLineNumber);
    }

    public String[] getSignature() {
        return this.signature;
    }

    public List<LocalVariable> getLocalVariables() {
        return this.localVariables;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Method) {
            Method mii = (Method)obj;
            return this.methodName.equals(mii.methodName) && this.className.equals(mii.className) && this.prototype.equals(mii.prototype);
        }
        return false;
    }

    @Override
    public int compareTo(Method method) {
        if (this == method) {
            return 0;
        }
        int compare = this.className.compareTo(method.className);
        if (compare != 0) {
            return compare;
        }
        compare = this.methodName.compareTo(method.methodName);
        if (compare != 0) {
            return compare;
        }
        return this.prototype.compareTo(method.prototype);
    }
}

