/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IOffsetInstruction;
import org.ow2.asmdex.instruction.IPseudoInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class PseudoInstructionSparseSwitch
extends Instruction
implements IPseudoInstruction {
    private static final int SPARSE_SWITCH_OPCODE = 512;
    private int[] keys;
    private Label[] targets;
    private IOffsetInstruction instructionSparseSwitch;

    @Override
    public IOffsetInstruction getSourceInstruction() {
        return this.instructionSparseSwitch;
    }

    public PseudoInstructionSparseSwitch(int[] keys, Label[] targets, IOffsetInstruction instructionSparseSwitch) {
        super(512);
        this.keys = keys;
        this.targets = targets;
        this.instructionSparseSwitch = instructionSparseSwitch;
    }

    @Override
    public int getSize() {
        return this.targets.length * 8 + 2 + 2;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(512);
        int size = this.targets.length;
        out.putShort(size);
        int i = 0;
        while (i < size) {
            out.putInt(this.keys[i]);
            ++i;
        }
        i = 0;
        while (i < size) {
            out.putInt((this.targets[i].getOffset() - this.instructionSparseSwitch.getInstructionOffset()) / 2);
            ++i;
        }
    }
}

