/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IIndexInstruction;
import org.ow2.asmdex.instruction.IRegisterArrayInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Method;

public class InstructionFormat3RC
extends Instruction
implements IRegisterArrayInstruction,
IIndexInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int[] registers;
    private int index;
    private String type;
    private Method method;

    @Override
    public int[] getRegisters() {
        return this.registers;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public static int getIndex(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static int[] getRegisters(IDalvikValueReader reader, int opcode) {
        int opcodeHighOrderByte;
        int nbRegisters = opcodeHighOrderByte = opcode >> 8 & 0xFF;
        int[] registers = new int[nbRegisters];
        int currentRegister = reader.ushort();
        int registerIndex = 0;
        while (registerIndex < nbRegisters) {
            registers[registerIndex] = currentRegister++;
            ++registerIndex;
        }
        return registers;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat3RC(int opcode, Method method, int[] registers) {
        super(opcode);
        this.method = method;
        this.registers = registers;
    }

    public InstructionFormat3RC(int opcode, String type, int[] registers) {
        super(opcode);
        this.type = type;
        this.registers = registers;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(((this.registers.length & 0xFF) << 8) + this.opcodeByte);
        if (this.opcodeByte == 37) {
            out.putShort(constantPool.getTypeIndex(this.type));
        } else {
            out.putShort(constantPool.getMethodIndex(this.method));
        }
        int regArg = this.registers.length > 0 ? this.registers[0] : 0;
        out.putShort(regArg);
    }
}

