/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IOffsetInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat10T
extends Instruction
implements IOffsetInstruction {
    private static final int INSTRUCTION_SIZE = 2;
    private int offset;
    private int instructionOffset;
    private Label label;

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    public static int getOffset(IDalvikValueReader reader, int opcode) {
        int readOffset = (byte)(opcode >> 8 & 0xFF) * 2;
        return reader.getPos() - 2 + readOffset;
    }

    public InstructionFormat10T(int opcode, Label label, int instructionOffset) {
        super(opcode);
        this.label = label;
        this.instructionOffset = instructionOffset;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public int getInstructionOffset() {
        return this.instructionOffset;
    }

    @Override
    public void setInstructionOffset(int instructionOffset) {
        this.instructionOffset = instructionOffset;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        int firstShort = (((this.label.getOffset() - this.instructionOffset) / 2 & 0xFF) << 8) + this.opcodeByte;
        out.putShort(firstShort);
    }
}

