/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.structureWriter.ConstantPool;

public abstract class Instruction {
    protected int opcodeHighOrderByte;
    protected int opcodeByte;
    protected int lineNumber;
    private static final byte[] instructionSizeInBytes = new byte[]{2, 2, 4, 6, 2, 4, 6, 2, 4, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 6, 4, 4, 6, 10, 4, 4, 6, 4, 2, 2, 4, 4, 2, 4, 4, 6, 6, 6, 2, 2, 4, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 2, 6, 6, 6, 6, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};

    public Instruction(int opcode) {
        this.opcodeHighOrderByte = opcode >> 8 & 0xFF;
        this.opcodeByte = opcode & 0xFF;
    }

    public abstract void write(ByteVector var1, ConstantPool var2);

    public abstract int getSize();

    public int getOpcodeHighOrderByte() {
        return this.opcodeHighOrderByte;
    }

    public int getOpcodeByte() {
        return this.opcodeByte;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public static void test4BitsLimit(int number) {
        if (number > 15) {
            throw new IllegalArgumentException("The number " + number + " can't be held in 4 bits !");
        }
    }

    public static void test4BitsLimit(int[] numbers) {
        int[] nArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            int number = nArray[n2];
            Instruction.test4BitsLimit(number);
            ++n2;
        }
    }

    public static byte getInstructionSizeInByte(int opcode) {
        return instructionSizeInBytes[opcode];
    }
}

